/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.connector.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.core.connector.url.StandardJdbcUrlParser;
import org.apache.shardingsphere.infra.database.core.connector.url.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.StorageResource;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapper;

public final class StorageResourceCreator {
    public static StorageResource createStorageResource(Map<String, DataSourcePoolProperties> propsMap) {
        LinkedHashMap<StorageNode, DataSource> storageNodes = new LinkedHashMap<StorageNode, DataSource>();
        LinkedHashMap<String, StorageUnitNodeMapper> mappers = new LinkedHashMap<String, StorageUnitNodeMapper>();
        for (Map.Entry<String, DataSourcePoolProperties> entry : propsMap.entrySet()) {
            String storageUnitName = entry.getKey();
            StorageUnitNodeMapper mapper = StorageResourceCreator.getStorageUnitNodeMapper(storageUnitName, entry.getValue());
            mappers.put(storageUnitName, mapper);
            storageNodes.computeIfAbsent(mapper.getStorageNode(), key -> DataSourcePoolCreator.create((String)storageUnitName, (DataSourcePoolProperties)((DataSourcePoolProperties)entry.getValue()), (boolean)true, storageNodes.values()));
        }
        return new StorageResource(storageNodes, mappers);
    }

    public static Map<String, StorageUnitNodeMapper> getStorageUnitNodeMappers(Map<String, DataSourcePoolProperties> propsMap) {
        LinkedHashMap<String, StorageUnitNodeMapper> result = new LinkedHashMap<String, StorageUnitNodeMapper>();
        for (Map.Entry<String, DataSourcePoolProperties> entry : propsMap.entrySet()) {
            String storageUnitName = entry.getKey();
            result.put(storageUnitName, StorageResourceCreator.getStorageUnitNodeMapper(storageUnitName, entry.getValue()));
        }
        return result;
    }

    private static StorageUnitNodeMapper getStorageUnitNodeMapper(String storageUnitName, DataSourcePoolProperties props) {
        Map standardProps = props.getConnectionPropertySynonyms().getStandardProperties();
        String url = standardProps.get("url").toString();
        boolean isInstanceConnectionAvailable = new DatabaseTypeRegistry(DatabaseTypeFactory.get((String)url)).getDialectDatabaseMetaData().isInstanceConnectionAvailable();
        StorageNode storageNode = new StorageNode(StorageResourceCreator.getStorageNodeName(storageUnitName, url, standardProps.get("username").toString(), isInstanceConnectionAvailable));
        return StorageResourceCreator.createStorageUnitNodeMapper(storageNode, storageUnitName, url, isInstanceConnectionAvailable);
    }

    private static String getStorageNodeName(String dataSourceName, String url, String username, boolean isInstanceConnectionAvailable) {
        try {
            JdbcUrl jdbcUrl = new StandardJdbcUrlParser().parse(url);
            return isInstanceConnectionAvailable ? StorageResourceCreator.generateStorageNodeName(jdbcUrl.getHostname(), jdbcUrl.getPort(), username) : dataSourceName;
        }
        catch (UnrecognizedDatabaseURLException ex) {
            return dataSourceName;
        }
    }

    private static String generateStorageNodeName(String hostname, int port, String username) {
        return String.format("%s_%s_%s", hostname, port, username);
    }

    private static StorageUnitNodeMapper createStorageUnitNodeMapper(StorageNode storageNode, String storageUnitName, String url, boolean isInstanceConnectionAvailable) {
        return isInstanceConnectionAvailable ? new StorageUnitNodeMapper(storageUnitName, storageNode, new StandardJdbcUrlParser().parse(url).getDatabase(), url) : new StorageUnitNodeMapper(storageUnitName, storageNode, url);
    }

    public static Map<StorageNode, DataSourcePoolProperties> getStorageNodeDataSourcePoolProperties(Map<String, DataSourcePoolProperties> storageUnitDataSourcePoolProps) {
        LinkedHashMap<StorageNode, DataSourcePoolProperties> result = new LinkedHashMap<StorageNode, DataSourcePoolProperties>();
        HashSet<StorageNode> storageNodes = new HashSet<StorageNode>();
        for (Map.Entry<String, DataSourcePoolProperties> entry : storageUnitDataSourcePoolProps.entrySet()) {
            Map standardProps = entry.getValue().getConnectionPropertySynonyms().getStandardProperties();
            String url = standardProps.get("url").toString();
            boolean isInstanceConnectionAvailable = new DatabaseTypeRegistry(DatabaseTypeFactory.get((String)url)).getDialectDatabaseMetaData().isInstanceConnectionAvailable();
            StorageNode storageNode = new StorageNode(StorageResourceCreator.getStorageNodeName(entry.getKey(), url, standardProps.get("username").toString(), isInstanceConnectionAvailable));
            if (!storageNodes.add(storageNode)) continue;
            result.put(storageNode, entry.getValue());
        }
        return result;
    }

    @Generated
    private StorageResourceCreator() {
    }
}

