/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource.unit;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.CatalogSwitchableDataSource;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapper;
import org.apache.shardingsphere.infra.state.datasource.DataSourceStateManager;

public final class StorageUnit {
    private final DataSourcePoolProperties dataSourcePoolProperties;
    private final StorageUnitNodeMapper unitNodeMapper;
    private final DataSource dataSource;
    private final DatabaseType storageType;
    private final ConnectionProperties connectionProperties;

    public StorageUnit(String databaseName, Map<StorageNode, DataSource> storageNodeDataSources, DataSourcePoolProperties props, StorageUnitNodeMapper unitNodeMapper) {
        this.dataSourcePoolProperties = props;
        this.unitNodeMapper = unitNodeMapper;
        this.dataSource = this.getStorageUnitDataSource(storageNodeDataSources, unitNodeMapper);
        Map<StorageNode, DataSource> enabledStorageNodeDataSources = this.getEnabledStorageNodeDataSources(databaseName, storageNodeDataSources);
        this.storageType = this.createStorageType(enabledStorageNodeDataSources, unitNodeMapper);
        this.connectionProperties = this.createConnectionProperties(enabledStorageNodeDataSources, unitNodeMapper, this.storageType).orElse(null);
    }

    private DataSource getStorageUnitDataSource(Map<StorageNode, DataSource> storageNodeDataSources, StorageUnitNodeMapper unitNodeMapper) {
        DataSource dataSource = storageNodeDataSources.get(unitNodeMapper.getStorageNode());
        return new CatalogSwitchableDataSource(dataSource, unitNodeMapper.getCatalog(), unitNodeMapper.getUrl());
    }

    private Map<StorageNode, DataSource> getEnabledStorageNodeDataSources(String databaseName, Map<StorageNode, DataSource> storageNodeDataSources) {
        LinkedHashMap<String, DataSource> toBeCheckedDataSources = new LinkedHashMap<String, DataSource>(storageNodeDataSources.size(), 1.0f);
        for (Map.Entry<StorageNode, DataSource> entry2 : storageNodeDataSources.entrySet()) {
            toBeCheckedDataSources.put(entry2.getKey().getName(), entry2.getValue());
        }
        Map<String, DataSource> enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSources(databaseName, toBeCheckedDataSources);
        return storageNodeDataSources.entrySet().stream().filter(entry -> enabledDataSources.containsKey(((StorageNode)entry.getKey()).getName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private DatabaseType createStorageType(Map<StorageNode, DataSource> enabledStorageNodeDataSources, StorageUnitNodeMapper unitNodeMapper) {
        return DatabaseTypeEngine.getStorageType(enabledStorageNodeDataSources.containsKey(unitNodeMapper.getStorageNode()) ? Collections.singleton(enabledStorageNodeDataSources.get(unitNodeMapper.getStorageNode())) : Collections.emptyList());
    }

    private Optional<ConnectionProperties> createConnectionProperties(Map<StorageNode, DataSource> enabledStorageNodeDataSources, StorageUnitNodeMapper unitNodeMapper, DatabaseType storageType) {
        if (!enabledStorageNodeDataSources.containsKey(unitNodeMapper.getStorageNode())) {
            return Optional.empty();
        }
        Map standardProps = DataSourcePoolPropertiesCreator.create((DataSource)enabledStorageNodeDataSources.get(unitNodeMapper.getStorageNode())).getConnectionPropertySynonyms().getStandardProperties();
        ConnectionPropertiesParser parser = (ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)storageType);
        return Optional.of(parser.parse(standardProps.get("url").toString(), standardProps.get("username").toString(), unitNodeMapper.getCatalog()));
    }

    @Generated
    public DataSourcePoolProperties getDataSourcePoolProperties() {
        return this.dataSourcePoolProperties;
    }

    @Generated
    public StorageUnitNodeMapper getUnitNodeMapper() {
        return this.unitNodeMapper;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public DatabaseType getStorageType() {
        return this.storageType;
    }

    @Generated
    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }
}

