/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapper;

public final class StorageUnitMetaData {
    private final Map<String, StorageUnitNodeMapper> unitNodeMappers;
    private final Map<String, StorageUnit> storageUnits;
    private final Map<String, DataSource> dataSources;

    public StorageUnitMetaData(String databaseName, Map<StorageNode, DataSource> storageNodeDataSources, Map<String, DataSourcePoolProperties> dataSourcePoolPropertiesMap, Map<String, StorageUnitNodeMapper> unitNodeMappers) {
        this.unitNodeMappers = unitNodeMappers;
        this.storageUnits = new LinkedHashMap<String, StorageUnit>(unitNodeMappers.size(), 1.0f);
        for (Map.Entry<String, StorageUnitNodeMapper> entry : unitNodeMappers.entrySet()) {
            this.storageUnits.put(entry.getKey(), new StorageUnit(databaseName, storageNodeDataSources, dataSourcePoolPropertiesMap.get(entry.getKey()), entry.getValue()));
        }
        this.dataSources = this.createDataSources();
    }

    public Map<String, DataSourcePoolProperties> getDataSourcePoolPropertiesMap() {
        return this.storageUnits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, DataSource> createDataSources() {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(this.storageUnits.size(), 1.0f);
        for (Map.Entry<String, StorageUnit> entry : this.storageUnits.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getDataSource());
        }
        return result;
    }

    @Generated
    public Map<String, StorageUnitNodeMapper> getUnitNodeMappers() {
        return this.unitNodeMappers;
    }

    @Generated
    public Map<String, StorageUnit> getStorageUnits() {
        return this.storageUnits;
    }

    @Generated
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }
}

