/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.KernelSupportedSystemTables;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.yaml.snakeyaml.Yaml;

public final class SystemSchemaBuilder {
    public static Map<String, ShardingSphereSchema> build(String databaseName, DatabaseType databaseType, ConfigurationProperties props) {
        SystemDatabase systemDatabase = new SystemDatabase(databaseType);
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(systemDatabase.getSystemSchemas().size(), 1.0f);
        boolean isSystemSchemaMetaDataEnabled = SystemSchemaBuilder.isSystemSchemaMetaDataEnabled(props.getProps());
        YamlTableSwapper swapper = new YamlTableSwapper();
        for (String each : SystemSchemaBuilder.getSystemSchemas(databaseName, databaseType, systemDatabase)) {
            result.put(each.toLowerCase(), SystemSchemaBuilder.createSchema(each, SystemSchemaBuilder.getSchemaStreams(each, databaseType), swapper, isSystemSchemaMetaDataEnabled));
        }
        return result;
    }

    private static boolean isSystemSchemaMetaDataEnabled(Properties props) {
        TemporaryConfigurationPropertyKey configKey = TemporaryConfigurationPropertyKey.SYSTEM_SCHEMA_METADATA_ENABLED;
        return Boolean.parseBoolean(props.getOrDefault((Object)configKey.getKey(), configKey.getDefaultValue()).toString());
    }

    private static Collection<String> getSystemSchemas(String originalDatabaseName, DatabaseType databaseType, SystemDatabase systemDatabase) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        String databaseName = dialectDatabaseMetaData.getDefaultSchema().isPresent() ? "postgres" : originalDatabaseName;
        return systemDatabase.getSystemDatabaseSchemaMap().getOrDefault(databaseName, Collections.emptyList());
    }

    private static Collection<InputStream> getSchemaStreams(String schemaName, DatabaseType databaseType) {
        SystemSchemaBuilderRule builderRule = SystemSchemaBuilderRule.valueOf(databaseType.getType(), schemaName);
        LinkedList<InputStream> result = new LinkedList<InputStream>();
        for (String each : builderRule.getTables()) {
            result.add(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/" + databaseType.getType().toLowerCase() + "/" + schemaName + "/" + each + ".yaml"));
        }
        return result;
    }

    private static ShardingSphereSchema createSchema(String schemaName, Collection<InputStream> schemaStreams, YamlTableSwapper swapper, boolean isSystemSchemaMetadataEnabled) {
        LinkedHashMap<String, ShardingSphereTable> tables = new LinkedHashMap<String, ShardingSphereTable>(schemaStreams.size(), 1.0f);
        for (InputStream each : schemaStreams) {
            YamlShardingSphereTable metaData = (YamlShardingSphereTable)new Yaml().loadAs(each, YamlShardingSphereTable.class);
            if (!isSystemSchemaMetadataEnabled && !KernelSupportedSystemTables.isSupportedSystemTable(schemaName, metaData.getName())) continue;
            tables.put(metaData.getName(), swapper.swapToObject(metaData));
        }
        return new ShardingSphereSchema(tables, Collections.emptyMap());
    }

    @Generated
    private SystemSchemaBuilder() {
    }
}

