/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.reviser.column;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.ColumnMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.MetaDataReviseEntry;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnDataTypeReviser;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnExistedReviser;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnGeneratedReviser;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnNameReviser;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ColumnReviseEngine<T extends ShardingSphereRule> {
    private final T rule;
    private final DatabaseType databaseType;
    private final DataSource dataSource;
    private final MetaDataReviseEntry<T> reviseEntry;

    public Collection<ColumnMetaData> revise(String tableName, Collection<ColumnMetaData> originalMetaDataList) {
        Optional<ColumnExistedReviser> existedReviser = this.reviseEntry.getColumnExistedReviser(this.rule, tableName);
        Optional<ColumnNameReviser> nameReviser = this.reviseEntry.getColumnNameReviser(this.rule, tableName);
        Optional<ColumnDataTypeReviser> dataTypeReviser = this.reviseEntry.getColumnDataTypeReviser(this.rule, tableName);
        Optional<ColumnGeneratedReviser> generatedReviser = this.reviseEntry.getColumnGeneratedReviser(this.rule, tableName);
        LinkedHashSet<ColumnMetaData> result = new LinkedHashSet<ColumnMetaData>();
        for (ColumnMetaData each : originalMetaDataList) {
            if (existedReviser.isPresent() && !existedReviser.get().isExisted(each.getName())) continue;
            String name = nameReviser.isPresent() ? nameReviser.get().revise(each.getName()) : each.getName();
            int dataType = dataTypeReviser.map(optional -> optional.revise(each.getName(), this.databaseType, this.dataSource).orElseGet(() -> ((ColumnMetaData)each).getDataType())).orElseGet(() -> ((ColumnMetaData)each).getDataType());
            boolean generated = generatedReviser.map(optional -> optional.revise(each)).orElseGet(() -> ((ColumnMetaData)each).isGenerated());
            result.add(new ColumnMetaData(name, dataType, each.isPrimaryKey(), generated, each.isCaseSensitive(), each.isVisible(), each.isUnsigned(), each.isNullable()));
        }
        return result;
    }

    @Generated
    public ColumnReviseEngine(T rule, DatabaseType databaseType, DataSource dataSource, MetaDataReviseEntry<T> reviseEntry) {
        this.rule = rule;
        this.databaseType = databaseType;
        this.dataSource = dataSource;
        this.reviseEntry = reviseEntry;
    }
}

