/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.reviser.table;

import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.MetaDataReviseEntry;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnReviseEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.constraint.ConstraintReviseEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.index.IndexReviseEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.table.TableNameReviser;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class TableMetaDataReviseEngine<T extends ShardingSphereRule> {
    private final T rule;
    private final DatabaseType databaseType;
    private final DataSource dataSource;
    private final MetaDataReviseEntry<T> reviseEntry;

    public TableMetaData revise(TableMetaData originalMetaData) {
        Optional<TableNameReviser<TableNameReviser>> tableNameReviser = this.reviseEntry.getTableNameReviser();
        String revisedTableName = tableNameReviser.map(optional -> optional.revise(originalMetaData.getName(), this.rule)).orElse(originalMetaData.getName());
        return new TableMetaData(revisedTableName, new ColumnReviseEngine<T>(this.rule, this.databaseType, this.dataSource, this.reviseEntry).revise(originalMetaData.getName(), originalMetaData.getColumns()), new IndexReviseEngine<T>(this.rule, this.reviseEntry).revise(originalMetaData.getName(), originalMetaData.getIndexes()), new ConstraintReviseEngine<T>(this.rule, this.reviseEntry).revise(originalMetaData.getName(), originalMetaData.getConstraints()));
    }

    @Generated
    public TableMetaDataReviseEngine(T rule, DatabaseType databaseType, DataSource dataSource, MetaDataReviseEntry<T> reviseEntry) {
        this.rule = rule;
        this.databaseType = databaseType;
        this.dataSource = dataSource;
        this.reviseEntry = reviseEntry;
    }
}

