/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.GlobalDataSourceRegistry;
import org.apache.shardingsphere.infra.database.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.exception.UnsupportedActualDataNodeStructureException;

public final class SchemaMetaDataUtils {
    public static Collection<MetaDataLoaderMaterial> getMetaDataLoaderMaterials(Collection<String> tableNames, GenericSchemaBuilderMaterial material, boolean checkMetaDataEnable) {
        LinkedHashMap<String, Collection<String>> dataSourceTableGroups = new LinkedHashMap<String, Collection<String>>();
        Collection<DatabaseType> unsupportedThreeTierStorageStructureDatabaseTypes = SchemaMetaDataUtils.getUnsupportedThreeTierStorageStructureDatabaseTypes(material.getStorageTypes().values());
        DataNodes dataNodes = new DataNodes(material.getRules());
        for (String each : tableNames) {
            SchemaMetaDataUtils.checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(unsupportedThreeTierStorageStructureDatabaseTypes, dataNodes, each);
            if (checkMetaDataEnable) {
                SchemaMetaDataUtils.addAllActualTableDataNode(material, dataSourceTableGroups, dataNodes, each);
                continue;
            }
            SchemaMetaDataUtils.addOneActualTableDataNode(material, dataSourceTableGroups, dataNodes, each);
        }
        LinkedList<MetaDataLoaderMaterial> result = new LinkedList<MetaDataLoaderMaterial>();
        for (Map.Entry entry : dataSourceTableGroups.entrySet()) {
            DatabaseType storageType = material.getStorageTypes().get(entry.getKey());
            String defaultSchemaName = SchemaMetaDataUtils.getDefaultSchemaNameByStorageType(storageType, material.getDefaultSchemaName());
            result.add(new MetaDataLoaderMaterial((Collection)entry.getValue(), SchemaMetaDataUtils.getDataSource(material, (String)entry.getKey()), storageType, defaultSchemaName));
        }
        return result;
    }

    private static String getDefaultSchemaNameByStorageType(DatabaseType storageType, String databaseName) {
        return new DatabaseTypeRegistry(storageType).getDefaultSchemaName(databaseName);
    }

    private static DataSource getDataSource(GenericSchemaBuilderMaterial material, String dataSourceName) {
        return material.getDataSourceMap().get(dataSourceName.contains(".") ? dataSourceName.split("\\.")[0] : dataSourceName);
    }

    private static void checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(Collection<DatabaseType> notSupportThreeTierStructureStorageTypes, DataNodes dataNodes, String tableName) {
        for (DataNode dataNode : dataNodes.getDataNodes(tableName)) {
            ShardingSpherePreconditions.checkState((notSupportThreeTierStructureStorageTypes.isEmpty() || !dataNode.getDataSourceName().contains(".") ? 1 : 0) != 0, () -> new UnsupportedActualDataNodeStructureException(dataNode, ((DatabaseType)notSupportThreeTierStructureStorageTypes.iterator().next()).getJdbcUrlPrefixes()));
            if (!dataNode.getDataSourceName().contains(".")) continue;
            String database = dataNode.getDataSourceName().split("\\.")[1];
            GlobalDataSourceRegistry.getInstance().getCachedDatabaseTables().put(dataNode.getTableName(), database);
        }
    }

    private static Collection<DatabaseType> getUnsupportedThreeTierStorageStructureDatabaseTypes(Collection<DatabaseType> storageTypes) {
        LinkedList<DatabaseType> result = new LinkedList<DatabaseType>();
        for (DatabaseType each : storageTypes) {
            if (new DatabaseTypeRegistry(each).getDialectDatabaseMetaData().isSupportThreeTierStorageStructure()) continue;
            result.add(each);
        }
        return result;
    }

    private static void addOneActualTableDataNode(GenericSchemaBuilderMaterial material, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Optional<DataNode> dataNode = dataNodes.getDataNodes(table).stream().filter(each -> SchemaMetaDataUtils.isSameDataSourceNameSchemaName(material, each)).findFirst();
        if (!dataNode.isPresent() && !material.getDataSourceMap().keySet().iterator().hasNext()) {
            return;
        }
        String dataSourceName = dataNode.map(DataNode::getDataSourceName).orElseGet(() -> material.getDataSourceMap().keySet().iterator().next());
        String tableName = dataNode.map(DataNode::getTableName).orElse(table);
        SchemaMetaDataUtils.addDataSourceTableGroups(dataSourceName, tableName, dataSourceTableGroups);
    }

    private static boolean isSameDataSourceNameSchemaName(GenericSchemaBuilderMaterial material, DataNode dataNode) {
        String dataSourceName;
        String string = dataSourceName = dataNode.getDataSourceName().contains(".") ? dataNode.getDataSourceName().split("\\.")[0] : dataNode.getDataSourceName();
        if (!material.getDataSourceMap().containsKey(dataSourceName)) {
            return false;
        }
        return null == dataNode.getSchemaName() || dataNode.getSchemaName().equalsIgnoreCase(material.getDefaultSchemaName());
    }

    private static void addAllActualTableDataNode(GenericSchemaBuilderMaterial material, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Collection<DataNode> tableDataNodes = dataNodes.getDataNodes(table);
        if (tableDataNodes.isEmpty()) {
            SchemaMetaDataUtils.addDataSourceTableGroups(material.getDataSourceMap().keySet().iterator().next(), table, dataSourceTableGroups);
        } else {
            tableDataNodes.forEach(each -> SchemaMetaDataUtils.addDataSourceTableGroups(each.getDataSourceName(), each.getTableName(), dataSourceTableGroups));
        }
    }

    private static void addDataSourceTableGroups(String dataSourceName, String tableName, Map<String, Collection<String>> dataSourceTableGroups) {
        Collection tables = dataSourceTableGroups.getOrDefault(dataSourceName, new LinkedList());
        tables.add(tableName);
        dataSourceTableGroups.putIfAbsent(dataSourceName, tables);
    }

    @Generated
    private SchemaMetaDataUtils() {
    }
}

