/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;

public final class ShardingSphereTableDataCollectorUtils {
    public static Collection<ShardingSphereRowData> collectRowData(ShardingSphereDatabase database, ShardingSphereTable table, Collection<String> selectedColumnNames, String sql) throws SQLException {
        if (ShardingSphereTableDataCollectorUtils.isDifferentProtocolAndStorageType(database)) {
            return Collections.emptyList();
        }
        LinkedList<ShardingSphereRowData> result = new LinkedList<ShardingSphereRowData>();
        for (StorageUnit each : database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits().values()) {
            Connection connection = each.getDataSource().getConnection();
            try {
                Statement statement = connection.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery(sql);
                    try {
                        result.addAll(ShardingSphereTableDataCollectorUtils.getRows(table, selectedColumnNames, resultSet));
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
        return result;
    }

    private static boolean isDifferentProtocolAndStorageType(ShardingSphereDatabase database) {
        return !database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits().values().stream().allMatch(each -> each.getStorageType().equals(database.getProtocolType()));
    }

    private static Collection<ShardingSphereRowData> getRows(ShardingSphereTable table, Collection<String> selectedColumnNames, ResultSet resultSet) throws SQLException {
        LinkedList<ShardingSphereRowData> result = new LinkedList<ShardingSphereRowData>();
        while (resultSet.next()) {
            result.add(new ShardingSphereRowData(ShardingSphereTableDataCollectorUtils.getRow(table, selectedColumnNames, resultSet)));
        }
        return result;
    }

    private static List<Object> getRow(ShardingSphereTable table, Collection<String> selectedColumnNames, ResultSet resultSet) throws SQLException {
        LinkedList<Object> result = new LinkedList<Object>();
        for (ShardingSphereColumn each : table.getColumnValues()) {
            result.add(selectedColumnNames.contains(each.getName()) ? ShardingSphereTableDataCollectorUtils.convertValueIfNecessary(resultSet.getObject(each.getName()), each.getDataType()) : ShardingSphereTableDataCollectorUtils.mockValue(each.getDataType()));
        }
        return result;
    }

    private static Object convertValueIfNecessary(Object data, int dataType) {
        if (null == data) {
            return null;
        }
        switch (dataType) {
            case 2003: {
                return data.toString();
            }
            case -5: {
                return Long.valueOf(data.toString());
            }
        }
        return data;
    }

    private static Object mockValue(int dataType) {
        switch (dataType) {
            case -5: {
                return 0L;
            }
            case 1: 
            case 12: 
            case 1111: 
            case 2003: {
                return "";
            }
            case 4: 
            case 5: {
                return 0;
            }
            case 7: {
                return Float.valueOf("0");
            }
            case -7: {
                return false;
            }
        }
        return null;
    }

    @Generated
    private ShardingSphereTableDataCollectorUtils() {
    }
}

