/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.tables;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereTableDataCollectorUtils;

public final class PgNamespaceTableCollector
implements ShardingSphereStatisticsCollector {
    private static final String PG_NAMESPACE = "pg_namespace";
    private static final String COLUMN_NAMES = "oid, nspname, nspowner, nspacl";
    private static final String SELECT_SQL = "SELECT oid, nspname, nspowner, nspacl FROM pg_catalog.pg_namespace";

    @Override
    public Optional<ShardingSphereTableData> collect(String databaseName, ShardingSphereTable table, Map<String, ShardingSphereDatabase> shardingSphereDatabases) throws SQLException {
        Collection<ShardingSphereRowData> rows = ShardingSphereTableDataCollectorUtils.collectRowData(shardingSphereDatabases.get(databaseName), table, Arrays.stream(COLUMN_NAMES.split(",")).map(String::trim).collect(Collectors.toList()), SELECT_SQL);
        ShardingSphereTableData result = new ShardingSphereTableData(PG_NAMESPACE);
        result.getRows().addAll(rows);
        return Optional.of(result);
    }

    public String getType() {
        return PG_NAMESPACE;
    }
}

