/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.session.connection.cursor.CursorConnectionContext;
import org.apache.shardingsphere.infra.session.connection.datasource.UsedDataSourceProvider;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;

public final class ConnectionContext
implements AutoCloseable {
    private final CursorConnectionContext cursorContext = new CursorConnectionContext();
    private final TransactionConnectionContext transactionContext = new TransactionConnectionContext();
    private final UsedDataSourceProvider usedDataSourceProvider;
    private String databaseName;
    private String trafficInstanceId;

    public ConnectionContext() {
        this(Collections::emptySet);
    }

    public Collection<String> getUsedDataSourceNames() {
        HashSet<String> result = new HashSet<String>(this.usedDataSourceProvider.getNames().size(), 1.0f);
        for (String each : this.usedDataSourceProvider.getNames()) {
            result.add(each.contains(".") ? each.split("\\.")[1] : each);
        }
        return result;
    }

    public Optional<String> getTrafficInstanceId() {
        return Optional.ofNullable(this.trafficInstanceId);
    }

    public void clearCursorContext() {
        this.cursorContext.close();
    }

    public void clearTransactionContext() {
        this.transactionContext.close();
    }

    public void setCurrentDatabase(String databaseName) {
        if (null != databaseName && !databaseName.equals(this.databaseName)) {
            this.databaseName = databaseName;
        }
    }

    public Optional<String> getDatabaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    @Override
    public void close() {
        this.trafficInstanceId = null;
        this.clearCursorContext();
        this.clearTransactionContext();
    }

    @Generated
    public ConnectionContext(UsedDataSourceProvider usedDataSourceProvider) {
        this.usedDataSourceProvider = usedDataSourceProvider;
    }

    @Generated
    public CursorConnectionContext getCursorContext() {
        return this.cursorContext;
    }

    @Generated
    public TransactionConnectionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Generated
    public void setTrafficInstanceId(String trafficInstanceId) {
        this.trafficInstanceId = trafficInstanceId;
    }
}

