/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.ShowReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ReadwriteSplittingRuleQueryResultSet
implements DistSQLResultSet {
    private static final String DYNAMIC = "Dynamic";
    private Iterator<Collection<Object>> data = Collections.emptyIterator();
    private Map<String, Map<String, String>> exportableAutoAwareDataSource = Collections.emptyMap();
    private Map<String, Map<String, String>> exportableDataSourceMap = Collections.emptyMap();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional ruleConfig = metaData.getRuleMetaData().findRuleConfiguration(ReadwriteSplittingRuleConfiguration.class).stream().findAny();
        this.buildExportableMap(metaData);
        ruleConfig.ifPresent(op -> {
            this.data = this.buildData((ReadwriteSplittingRuleConfiguration)op).iterator();
        });
    }

    private void buildExportableMap(ShardingSphereMetaData metaData) {
        Optional<ExportableRule> exportableRule = this.getExportableRule(metaData);
        exportableRule.ifPresent(op -> {
            Map exportable = ((ExportableRule)exportableRule.get()).export(Arrays.asList("auto_aware_data_source", "data_source"));
            this.exportableAutoAwareDataSource = exportable.getOrDefault("auto_aware_data_source", Collections.emptyMap());
            this.exportableDataSourceMap = exportable.getOrDefault("data_source", Collections.emptyMap());
        });
    }

    private Optional<ExportableRule> getExportableRule(ShardingSphereMetaData metaData) {
        return metaData.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Arrays.asList("auto_aware_data_source", "data_source"))).findAny();
    }

    private Collection<Collection<Object>> buildData(ReadwriteSplittingRuleConfiguration configuration) {
        LinkedList<Collection<Object>> result = new LinkedList<Collection<Object>>();
        configuration.getDataSources().forEach(each -> {
            Collection<Object> dataItem = this.buildDataItem((ReadwriteSplittingDataSourceRuleConfiguration)each, this.getLoadBalancers(configuration));
            result.add(dataItem);
        });
        return result;
    }

    private Collection<Object> buildDataItem(ReadwriteSplittingDataSourceRuleConfiguration dataSourceConfiguration, Map<String, ShardingSphereAlgorithmConfiguration> loadBalancers) {
        String name = dataSourceConfiguration.getName();
        Map<String, String> exportDataSources = DYNAMIC.equalsIgnoreCase(dataSourceConfiguration.getType()) ? this.exportableAutoAwareDataSource.get(name) : this.exportableDataSourceMap.get(name);
        Optional<ShardingSphereAlgorithmConfiguration> loadBalancer = Optional.ofNullable(loadBalancers.get(dataSourceConfiguration.getLoadBalancerName()));
        return Arrays.asList(name, dataSourceConfiguration.getAutoAwareDataSourceName().orElse(null), this.getWriteDataSourceName(dataSourceConfiguration, exportDataSources), this.getReadDataSourceNames(dataSourceConfiguration, exportDataSources), loadBalancer.map(TypedSPIConfiguration::getType).orElse(null), loadBalancer.map(each -> PropertiesConverter.convert((Properties)each.getProps())).orElse(""));
    }

    private Map<String, ShardingSphereAlgorithmConfiguration> getLoadBalancers(ReadwriteSplittingRuleConfiguration configuration) {
        Map<String, ShardingSphereAlgorithmConfiguration> loadBalancers = configuration.getLoadBalancers();
        return null != loadBalancers ? loadBalancers : Collections.emptyMap();
    }

    private String getWriteDataSourceName(ReadwriteSplittingDataSourceRuleConfiguration dataSourceConfiguration, Map<String, String> exportDataSources) {
        if (null != exportDataSources) {
            return exportDataSources.get("primary_data_source_name");
        }
        return dataSourceConfiguration.getWriteDataSourceName().orElse("");
    }

    private String getReadDataSourceNames(ReadwriteSplittingDataSourceRuleConfiguration dataSourceConfiguration, Map<String, String> exportDataSources) {
        if (null != exportDataSources) {
            return exportDataSources.get("replica_data_source_names");
        }
        return dataSourceConfiguration.getReadDataSourceNames().orElse("");
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "auto_aware_data_source_name", "write_data_source_name", "read_data_source_names", "load_balancer_type", "load_balancer_props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowReadwriteSplittingRulesStatement.class.getName();
    }
}

