/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.yaml.swapper;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.swapper.algorithm.ShardingSphereAlgorithmConfigurationYamlSwapper;
import org.apache.shardingsphere.replicaquery.api.config.ReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.rule.ReplicaQueryDataSourceRuleConfiguration;
import org.apache.shardingsphere.replicaquery.yaml.config.YamlReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.yaml.config.rule.YamlReplicaQueryDataSourceRuleConfiguration;

public final class ReplicaQueryRuleConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlReplicaQueryRuleConfiguration, ReplicaQueryRuleConfiguration> {
    private final ShardingSphereAlgorithmConfigurationYamlSwapper algorithmSwapper = new ShardingSphereAlgorithmConfigurationYamlSwapper();

    public YamlReplicaQueryRuleConfiguration swapToYamlConfiguration(ReplicaQueryRuleConfiguration data) {
        YamlReplicaQueryRuleConfiguration result = new YamlReplicaQueryRuleConfiguration();
        result.setDataSources(data.getDataSources().stream().collect(Collectors.toMap(ReplicaQueryDataSourceRuleConfiguration::getName, this::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        if (null != data.getLoadBalancers()) {
            data.getLoadBalancers().forEach((key, value) -> result.getLoadBalancers().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        }
        return result;
    }

    private YamlReplicaQueryDataSourceRuleConfiguration swapToYamlConfiguration(ReplicaQueryDataSourceRuleConfiguration dataSourceRuleConfig) {
        YamlReplicaQueryDataSourceRuleConfiguration result = new YamlReplicaQueryDataSourceRuleConfiguration();
        result.setName(dataSourceRuleConfig.getName());
        result.setPrimaryDataSourceName(dataSourceRuleConfig.getPrimaryDataSourceName());
        result.setReplicaDataSourceNames(dataSourceRuleConfig.getReplicaDataSourceNames());
        result.setLoadBalancerName(dataSourceRuleConfig.getLoadBalancerName());
        return result;
    }

    public ReplicaQueryRuleConfiguration swapToObject(YamlReplicaQueryRuleConfiguration yamlConfig) {
        LinkedList<ReplicaQueryDataSourceRuleConfiguration> dataSources = new LinkedList<ReplicaQueryDataSourceRuleConfiguration>();
        for (Map.Entry<String, YamlReplicaQueryDataSourceRuleConfiguration> entry : yamlConfig.getDataSources().entrySet()) {
            dataSources.add(this.swapToObject(entry.getKey(), entry.getValue()));
        }
        LinkedHashMap loadBalancers = new LinkedHashMap(yamlConfig.getLoadBalancers().entrySet().size(), 1.0f);
        if (null != yamlConfig.getLoadBalancers()) {
            yamlConfig.getLoadBalancers().forEach((key, value) -> loadBalancers.put(key, this.algorithmSwapper.swapToObject(value)));
        }
        return new ReplicaQueryRuleConfiguration(dataSources, loadBalancers);
    }

    private ReplicaQueryDataSourceRuleConfiguration swapToObject(String name, YamlReplicaQueryDataSourceRuleConfiguration yamlDataSourceRuleConfig) {
        return new ReplicaQueryDataSourceRuleConfiguration(name, yamlDataSourceRuleConfig.getPrimaryDataSourceName(), yamlDataSourceRuleConfig.getReplicaDataSourceNames(), yamlDataSourceRuleConfig.getLoadBalancerName());
    }

    public Class<ReplicaQueryRuleConfiguration> getTypeClass() {
        return ReplicaQueryRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "REPLICA_QUERY";
    }

    public int getOrder() {
        return 10;
    }
}

