/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.spring.namespace.parser;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.replicaquery.algorithm.config.AlgorithmProvidedReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.rule.ReplicaQueryDataSourceRuleConfiguration;
import org.apache.shardingsphere.replicaquery.spring.namespace.factorybean.ReplicaLoadBalanceAlgorithmFactoryBean;
import org.apache.shardingsphere.spring.namespace.registry.ShardingSphereAlgorithmBeanRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class ReplicaQueryRuleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(AlgorithmProvidedReplicaQueryRuleConfiguration.class);
        factory.addConstructorArgValue(this.parseReplicaQueryDataSourceRuleConfigurations(element));
        factory.addConstructorArgValue((Object)ShardingSphereAlgorithmBeanRegistry.getAlgorithmBeanReferences((ParserContext)parserContext, ReplicaLoadBalanceAlgorithmFactoryBean.class));
        return factory.getBeanDefinition();
    }

    private List<BeanDefinition> parseReplicaQueryDataSourceRuleConfigurations(Element element) {
        List dataSourceElements = DomUtils.getChildElementsByTagName((Element)element, (String)"data-source-rule");
        ManagedList result = new ManagedList(dataSourceElements.size());
        for (Element each : dataSourceElements) {
            result.add(this.parseReplicaQueryDataSourceRuleConfiguration(each));
        }
        return result;
    }

    private BeanDefinition parseReplicaQueryDataSourceRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ReplicaQueryDataSourceRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("id"));
        factory.addConstructorArgValue((Object)element.getAttribute("primary-data-source-name"));
        factory.addConstructorArgValue(this.parseReplicaDataSourcesRef(element));
        factory.addConstructorArgValue((Object)element.getAttribute("load-balance-algorithm-ref"));
        return factory.getBeanDefinition();
    }

    private Collection<String> parseReplicaDataSourcesRef(Element element) {
        List replicaDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("replica-data-source-names"));
        ManagedList result = new ManagedList(replicaDataSources.size());
        result.addAll(replicaDataSources);
        return result;
    }
}

