/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.scope.SchemaRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.AlgorithmInUsedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.converter.ShadowRuleStatementConverter;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowRuleSegment;
import org.apache.shardingsphere.shadow.distsql.parser.statement.AlterShadowRuleStatement;

public final class AlterShadowRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterShadowRuleStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public RuleConfiguration buildToBeAlteredRuleConfiguration(AlterShadowRuleStatement sqlStatement) {
        return ShadowRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(ShadowRuleConfiguration currentRuleConfig, ShadowRuleConfiguration toBeAlteredRuleConfig) {
        this.updateDataSources(currentRuleConfig, toBeAlteredRuleConfig.getDataSources());
        this.updateTables(currentRuleConfig.getTables(), toBeAlteredRuleConfig.getTables());
        currentRuleConfig.getShadowAlgorithms().putAll(toBeAlteredRuleConfig.getShadowAlgorithms());
    }

    private void updateDataSources(ShadowRuleConfiguration currentRuleConfig, Map<String, ShadowDataSourceConfiguration> toBeAlteredDataSources) {
        currentRuleConfig.getTables().values().forEach(tableConfig -> tableConfig.getDataSourceNames().removeIf(toBeAlteredDataSources::containsKey));
        currentRuleConfig.getDataSources().putAll(toBeAlteredDataSources);
    }

    private void updateTables(Map<String, ShadowTableConfiguration> currentTables, Map<String, ShadowTableConfiguration> toBeAlteredTables) {
        toBeAlteredTables.forEach(currentTables::replace);
    }

    public void checkSQLStatement(ShardingSphereMetaData metaData, AlterShadowRuleStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = metaData.getName();
        Collection rules = sqlStatement.getRules();
        this.checkConfigurationExist(schemaName, (SchemaRuleConfiguration)currentRuleConfig);
        this.checkRuleNames(schemaName, rules, currentRuleConfig);
        this.checkResources(schemaName, rules, metaData);
        this.checkAlgorithms(schemaName, rules);
    }

    private void checkConfigurationExist(String schemaName, SchemaRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShadowRuleStatementChecker.checkConfigurationExist(schemaName, currentRuleConfig);
    }

    private void checkRuleNames(String schemaName, Collection<ShadowRuleSegment> rules, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        List<String> currentRuleNames = ShadowRuleStatementSupporter.getRuleNames(currentRuleConfig);
        List<String> requireRuleNames = ShadowRuleStatementSupporter.getRuleNames(rules);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireRuleNames, duplicate -> new DuplicateRuleException(SHADOW, schemaName, duplicate));
        ShadowRuleStatementChecker.checkRulesExist(requireRuleNames, currentRuleNames, different -> new InvalidAlgorithmConfigurationException("shadow rule name ", different));
    }

    private void checkResources(String schemaName, Collection<ShadowRuleSegment> rules, ShardingSphereMetaData metaData) throws DistSQLException {
        List<String> requireResource = ShadowRuleStatementSupporter.getResourceNames(rules);
        ShadowRuleStatementChecker.checkResourceExist(requireResource, metaData, schemaName);
    }

    private void checkAlgorithms(String schemaName, Collection<ShadowRuleSegment> rules) throws DistSQLException {
        List<ShadowAlgorithmSegment> shadowAlgorithmSegment = ShadowRuleStatementSupporter.getShadowAlgorithmSegment(rules);
        ShadowRuleStatementChecker.checkAlgorithmCompleteness(shadowAlgorithmSegment);
        List<String> requireAlgorithms = ShadowRuleStatementSupporter.getAlgorithmNames(rules);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithms, duplicate -> new AlgorithmInUsedException(schemaName, duplicate));
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return AlterShadowRuleStatement.class.getName();
    }
}

