/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.inline;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.util.Expando;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.sharding.algorithm.sharding.inline.InlineExpressionParser;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class InlineShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String ALLOW_RANGE_QUERY_KEY = "allow-range-query-with-inline-sharding";
    private boolean allowRangeQuery;
    private Properties props = new Properties();

    public void init() {
        this.allowRangeQuery = this.isAllowRangeQuery();
    }

    private Closure<?> createClosure() {
        String expression = this.props.getProperty(ALGORITHM_EXPRESSION_KEY);
        Preconditions.checkNotNull((Object)expression, (Object)"Inline sharding algorithm expression cannot be null.");
        String algorithmExpression = InlineExpressionParser.handlePlaceHolder(expression.trim());
        Closure result = new InlineExpressionParser(algorithmExpression).evaluateClosure().rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        return result;
    }

    private boolean isAllowRangeQuery() {
        return Boolean.parseBoolean(this.props.getOrDefault((Object)ALLOW_RANGE_QUERY_KEY, Boolean.FALSE.toString()).toString());
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        Closure<?> closure = this.createClosure();
        closure.setProperty(shardingValue.getColumnName(), (Object)shardingValue.getValue());
        return closure.call().toString();
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        if (this.allowRangeQuery) {
            return availableTargetNames;
        }
        throw new UnsupportedOperationException("Since the property of `allow-range-query-with-inline-sharding` is false, inline sharding algorithm can not tackle with range query.");
    }

    public String getType() {
        return "INLINE";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

