/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata;

import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaData;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaDataDecorator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingTableAddressingMetaDataDecorator
implements TableAddressingMetaDataDecorator<ShardingRule> {
    public void decorate(ShardingRule rule, TableAddressingMetaData metaData) {
        rule.getTableRules().forEach(each -> this.decorate((TableRule)each, metaData));
    }

    private void decorate(TableRule tableRule, TableAddressingMetaData metaData) {
        boolean found = false;
        for (String each : tableRule.getActualDataNodes().stream().map(DataNode::getTableName).collect(Collectors.toSet())) {
            found = null != metaData.getTableDataSourceNamesMapper().remove(each) || found;
        }
        if (found) {
            metaData.getTableDataSourceNamesMapper().put(tableRule.getLogicTable(), new LinkedList<String>(tableRule.getActualDatasourceNames()));
        }
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

