/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.DataNodeRoutedRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.algorithm.sharding.inline.InlineExpressionParser;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ShardingRule
implements DataNodeRoutedRule {
    private final Collection<String> dataSourceNames;
    private final Map<String, ShardingAlgorithm> shardingAlgorithms = new LinkedHashMap<String, ShardingAlgorithm>();
    private final Map<String, KeyGenerateAlgorithm> keyGenerators = new LinkedHashMap<String, KeyGenerateAlgorithm>();
    private final Collection<TableRule> tableRules;
    private final Collection<BindingTableRule> bindingTableRules;
    private final Collection<String> broadcastTables;
    private final ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig;
    private final ShardingStrategyConfiguration defaultTableShardingStrategyConfig;
    private final KeyGenerateAlgorithm defaultKeyGenerateAlgorithm;

    public ShardingRule(ShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        Preconditions.checkArgument((null != config ? 1 : 0) != 0, (Object)"Sharding rule configuration cannot be null.");
        Preconditions.checkArgument((null != dataSourceNames && !dataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"Data sources cannot be empty.");
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), dataSourceNames);
        config.getShardingAlgorithms().forEach((key, value) -> this.shardingAlgorithms.put((String)key, (ShardingAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, ShardingAlgorithm.class)));
        config.getKeyGenerators().forEach((key, value) -> this.keyGenerators.put((String)key, (KeyGenerateAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, KeyGenerateAlgorithm.class)));
        this.tableRules = new LinkedList<TableRule>(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.addAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.broadcastTables = config.getBroadcastTables();
        this.bindingTableRules = this.createBindingTableRules(config.getBindingTableGroups());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? (KeyGenerateAlgorithm)TypedSPIRegistry.getRegisteredService(KeyGenerateAlgorithm.class) : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
    }

    public ShardingRule(AlgorithmProvidedShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        Preconditions.checkArgument((null != config ? 1 : 0) != 0, (Object)"Sharding rule configuration cannot be null.");
        Preconditions.checkArgument((null != dataSourceNames && !dataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"Data sources cannot be empty.");
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), dataSourceNames);
        this.shardingAlgorithms.putAll(config.getShardingAlgorithms());
        this.keyGenerators.putAll(config.getKeyGenerators());
        this.tableRules = new LinkedList<TableRule>(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.addAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.broadcastTables = config.getBroadcastTables();
        this.bindingTableRules = this.createBindingTableRules(config.getBindingTableGroups());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? (KeyGenerateAlgorithm)TypedSPIRegistry.getRegisteredService(KeyGenerateAlgorithm.class) : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
    }

    private Collection<String> getDataSourceNames(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, Collection<String> dataSourceNames) {
        if (tableRuleConfigs.isEmpty()) {
            return dataSourceNames;
        }
        if (tableRuleConfigs.stream().map(ShardingTableRuleConfiguration::getActualDataNodes).anyMatch(each -> null == each || each.isEmpty())) {
            return dataSourceNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        tableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingTableRuleConfiguration)each)));
        return result;
    }

    private Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        List<String> actualDataNodes = new InlineExpressionParser(shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        return actualDataNodes.stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private Collection<TableRule> createTableRules(Collection<ShardingTableRuleConfiguration> tableRuleConfigurations, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return tableRuleConfigurations.stream().map(each -> new TableRule((ShardingTableRuleConfiguration)each, this.dataSourceNames, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig))).collect(Collectors.toList());
    }

    private Collection<TableRule> createAutoTableRules(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigurations, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return autoTableRuleConfigurations.stream().map(each -> this.createAutoTableRule(defaultKeyGenerateStrategyConfig, (ShardingAutoTableRuleConfiguration)each)).collect(Collectors.toList());
    }

    private TableRule createAutoTableRule(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration each) {
        ShardingAlgorithm shardingAlgorithm = null == each.getShardingStrategy() ? null : this.shardingAlgorithms.get(each.getShardingStrategy().getShardingAlgorithmName());
        Preconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), (Object)"Sharding auto table rule configuration must match sharding auto table algorithm.");
        return new TableRule(each, this.dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private String getDefaultGenerateKeyColumn(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return Optional.ofNullable(defaultKeyGenerateStrategyConfig).map(KeyGenerateStrategyConfiguration::getColumn).orElse(null);
    }

    private Collection<BindingTableRule> createBindingTableRules(Collection<String> bindingTableGroups) {
        return bindingTableGroups.stream().map(this::createBindingTableRule).collect(Collectors.toList());
    }

    private BindingTableRule createBindingTableRule(String bindingTableGroup) {
        return new BindingTableRule(Splitter.on((String)",").trimResults().splitToList((CharSequence)bindingTableGroup).stream().map(this::getTableRule).collect(Collectors.toList()));
    }

    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategyConfig() ? this.defaultDatabaseShardingStrategyConfig : tableRule.getDatabaseShardingStrategyConfig();
    }

    public ShardingStrategyConfiguration getTableShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategyConfig() ? this.defaultTableShardingStrategyConfig : tableRule.getTableShardingStrategyConfig();
    }

    public Optional<TableRule> findTableRule(String logicTableName) {
        return this.tableRules.stream().filter(each -> each.getLogicTable().equalsIgnoreCase(logicTableName)).findFirst();
    }

    public Optional<TableRule> findTableRuleByActualTable(String actualTableName) {
        return this.tableRules.stream().filter(each -> each.isExisted(actualTableName)).findFirst();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (tableRule.isPresent()) {
            return tableRule.get();
        }
        if (this.isBroadcastTable(logicTableName)) {
            return new TableRule(this.dataSourceNames, logicTableName);
        }
        throw new ShardingSphereConfigurationException("Cannot find table rule with logic table: '%s'", new Object[]{logicTableName});
    }

    public boolean isAllBindingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTableNames);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(bindingTableRule.get().getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTableNames);
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTableNames) {
        return logicTableNames.stream().map(this::findBindingTableRule).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTableName) {
        return this.bindingTableRules.stream().filter(each -> each.hasLogicTable(logicTableName)).findFirst();
    }

    public boolean isAllBroadcastTables(Collection<String> logicTableNames) {
        return !logicTableNames.isEmpty() && logicTableNames.stream().allMatch(this::isBroadcastTable);
    }

    public boolean isBroadcastTable(String logicTableName) {
        return this.broadcastTables.stream().anyMatch(each -> each.equalsIgnoreCase(logicTableName));
    }

    public boolean tableRuleExists(Collection<String> logicTableNames) {
        return logicTableNames.stream().anyMatch(each -> this.findTableRule((String)each).isPresent() || this.isBroadcastTable((String)each));
    }

    public boolean isShardingColumn(String columnName, String tableName) {
        return this.tableRules.stream().anyMatch(each -> each.getLogicTable().equalsIgnoreCase(tableName) && this.isShardingColumn((TableRule)each, columnName));
    }

    private boolean isShardingColumn(TableRule tableRule, String columnName) {
        return this.isShardingColumn(this.getDatabaseShardingStrategyConfiguration(tableRule), columnName) || this.isShardingColumn(this.getTableShardingStrategyConfiguration(tableRule), columnName);
    }

    private boolean isShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String columnName) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            return ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn().equalsIgnoreCase(columnName);
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            return ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns().contains(columnName);
        }
        return false;
    }

    public boolean isGenerateKeyColumn(String columnName, String tableName) {
        return this.tableRules.stream().anyMatch(each -> each.getLogicTable().equalsIgnoreCase(tableName) && this.isGenerateKeyColumn((TableRule)each, columnName));
    }

    private boolean isGenerateKeyColumn(TableRule tableRule, String columnName) {
        Optional<String> generateKeyColumn = tableRule.getGenerateKeyColumn();
        return generateKeyColumn.isPresent() && generateKeyColumn.get().equalsIgnoreCase(columnName);
    }

    public Optional<String> findGenerateKeyColumnName(String logicTableName) {
        return this.tableRules.stream().filter(each -> each.getLogicTable().equalsIgnoreCase(logicTableName) && each.getGenerateKeyColumn().isPresent()).map(TableRule::getGenerateKeyColumn).findFirst().orElse(Optional.empty());
    }

    public Comparable<?> generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingSphereConfigurationException("Cannot find strategy for generate keys.", new Object[0]);
        }
        KeyGenerateAlgorithm keyGenerator = null != tableRule.get().getKeyGeneratorName() ? this.keyGenerators.get(tableRule.get().getKeyGeneratorName()) : this.defaultKeyGenerateAlgorithm;
        return keyGenerator.generateKey();
    }

    public DataNode getDataNode(String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        return tableRule.getActualDataNodes().get(0);
    }

    public DataNode getDataNode(String dataSourceName, String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        return tableRule.getActualDataNodes().stream().filter(each -> this.dataSourceNames.contains(each.getDataSourceName()) && each.getDataSourceName().equals(dataSourceName)).findFirst().orElseThrow(() -> new ShardingSphereConfigurationException("Cannot find actual data node for data source name: '%s' and logic table name: '%s'", new Object[]{dataSourceName, logicTableName}));
    }

    public Collection<String> getShardingLogicTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(each -> this.findTableRule((String)each).isPresent()).collect(Collectors.toCollection(LinkedList::new));
    }

    public Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.findBindingTableRule(logicTable).ifPresent(bindingTableRule -> result.putAll(bindingTableRule.getLogicAndActualTables(dataSourceName, logicTable, actualTable, availableLogicBindingTables)));
        return result;
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.tableRules.stream().collect(Collectors.toMap(TableRule::getLogicTable, TableRule::getActualDataNodes, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Collection<String> getAllActualTables() {
        return this.tableRules.stream().flatMap(each -> each.getActualDataNodes().stream().map(DataNode::getTableName)).collect(Collectors.toSet());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return this.findTableRule(logicTable).map(tableRule -> tableRule.getActualDataNodes().get(0).getTableName());
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return !this.isAllBroadcastTables(tables);
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return this.findTableRuleByActualTable(actualTable).map(TableRule::getLogicTable);
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, ShardingAlgorithm> getShardingAlgorithms() {
        return this.shardingAlgorithms;
    }

    @Generated
    public Map<String, KeyGenerateAlgorithm> getKeyGenerators() {
        return this.keyGenerators;
    }

    @Generated
    public Collection<TableRule> getTableRules() {
        return this.tableRules;
    }

    @Generated
    public Collection<BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    @Generated
    public Collection<String> getBroadcastTables() {
        return this.broadcastTables;
    }

    @Generated
    public KeyGenerateAlgorithm getDefaultKeyGenerateAlgorithm() {
        return this.defaultKeyGenerateAlgorithm;
    }

    static {
        ShardingSphereServiceLoader.register(ShardingAlgorithm.class);
        ShardingSphereServiceLoader.register(KeyGenerateAlgorithm.class);
    }
}

