/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.yaml.swapper.strategy;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.yaml.swapper.YamlSwapper;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlHintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlNoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlStandardShardingStrategyConfiguration;

public final class ShardingStrategyConfigurationYamlSwapper
implements YamlSwapper<YamlShardingStrategyConfiguration, ShardingStrategyConfiguration> {
    public YamlShardingStrategyConfiguration swapToYamlConfiguration(ShardingStrategyConfiguration data) {
        YamlShardingStrategyConfiguration result = new YamlShardingStrategyConfiguration();
        if (data instanceof StandardShardingStrategyConfiguration) {
            result.setStandard(this.createYamlStandardShardingStrategyConfiguration((StandardShardingStrategyConfiguration)data));
        }
        if (data instanceof ComplexShardingStrategyConfiguration) {
            result.setComplex(this.createYamlComplexShardingStrategyConfiguration((ComplexShardingStrategyConfiguration)data));
        }
        if (data instanceof HintShardingStrategyConfiguration) {
            result.setHint(this.createYamlHintShardingStrategyConfiguration((HintShardingStrategyConfiguration)data));
        }
        if (data instanceof NoneShardingStrategyConfiguration) {
            result.setNone(new YamlNoneShardingStrategyConfiguration());
        }
        return result;
    }

    public ShardingStrategyConfiguration swapToObject(YamlShardingStrategyConfiguration yamlConfig) {
        int shardingStrategyConfigCount = 0;
        StandardShardingStrategyConfiguration result = null;
        if (null != yamlConfig.getStandard()) {
            ++shardingStrategyConfigCount;
            result = this.createStandardShardingStrategyConfiguration(yamlConfig.getStandard());
        }
        if (null != yamlConfig.getComplex()) {
            ++shardingStrategyConfigCount;
            result = this.createComplexShardingStrategyConfiguration(yamlConfig.getComplex());
        }
        if (null != yamlConfig.getHint()) {
            ++shardingStrategyConfigCount;
            result = this.createHintShardingStrategyConfiguration(yamlConfig.getHint());
        }
        if (null != yamlConfig.getNone()) {
            ++shardingStrategyConfigCount;
            result = new NoneShardingStrategyConfiguration();
        }
        Preconditions.checkArgument((shardingStrategyConfigCount <= 1 ? 1 : 0) != 0, (Object)"Only allowed 0 or 1 sharding strategy configuration.");
        return result;
    }

    private YamlStandardShardingStrategyConfiguration createYamlStandardShardingStrategyConfiguration(StandardShardingStrategyConfiguration data) {
        YamlStandardShardingStrategyConfiguration result = new YamlStandardShardingStrategyConfiguration();
        result.setShardingColumn(data.getShardingColumn());
        result.setShardingAlgorithmName(data.getShardingAlgorithmName());
        return result;
    }

    private YamlComplexShardingStrategyConfiguration createYamlComplexShardingStrategyConfiguration(ComplexShardingStrategyConfiguration data) {
        YamlComplexShardingStrategyConfiguration result = new YamlComplexShardingStrategyConfiguration();
        result.setShardingColumns(data.getShardingColumns());
        result.setShardingAlgorithmName(data.getShardingAlgorithmName());
        return result;
    }

    private YamlHintShardingStrategyConfiguration createYamlHintShardingStrategyConfiguration(HintShardingStrategyConfiguration data) {
        YamlHintShardingStrategyConfiguration result = new YamlHintShardingStrategyConfiguration();
        result.setShardingAlgorithmName(data.getShardingAlgorithmName());
        return result;
    }

    private StandardShardingStrategyConfiguration createStandardShardingStrategyConfiguration(YamlStandardShardingStrategyConfiguration yamlConfig) {
        return new StandardShardingStrategyConfiguration(yamlConfig.getShardingColumn(), yamlConfig.getShardingAlgorithmName());
    }

    private ComplexShardingStrategyConfiguration createComplexShardingStrategyConfiguration(YamlComplexShardingStrategyConfiguration yamlConfig) {
        return new ComplexShardingStrategyConfiguration(yamlConfig.getShardingColumns(), yamlConfig.getShardingAlgorithmName());
    }

    private HintShardingStrategyConfiguration createHintShardingStrategyConfiguration(YamlHintShardingStrategyConfiguration yamlConfig) {
        return new HintShardingStrategyConfiguration(yamlConfig.getShardingAlgorithmName());
    }
}

