/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.OffsetToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.NumberLiteralPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;

public final class OffsetTokenGenerator
implements OptionalSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getPaginationContext().getOffsetSegment().isPresent() && ((SelectStatementContext)sqlStatementContext).getPaginationContext().getOffsetSegment().get() instanceof NumberLiteralPaginationValueSegment;
    }

    public OffsetToken generateSQLToken(SelectStatementContext selectStatementContext) {
        PaginationContext pagination = selectStatementContext.getPaginationContext();
        Preconditions.checkState((boolean)pagination.getOffsetSegment().isPresent());
        return new OffsetToken(((PaginationValueSegment)pagination.getOffsetSegment().get()).getStartIndex(), ((PaginationValueSegment)pagination.getOffsetSegment().get()).getStopIndex(), pagination.getRevisedOffset());
    }
}

