/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.tree.TreeEnsembleParams$;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class DecisionTreeMetadata$
implements Logging,
Serializable {
    public static final DecisionTreeMetadata$ MODULE$ = new DecisionTreeMetadata$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DecisionTreeMetadata buildMetadata(RDD<Instance> input, Strategy strategy, int numTrees, String featureSubsetStrategy) {
        int n;
        int[] numBins;
        HashSet unorderedFeatures;
        int numClasses;
        double weightSum;
        long numExamples;
        int numFeatures;
        block21: {
            String _featureSubsetStrategy;
            String string;
            block20: {
                int n2;
                numFeatures = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.intArrayOps((int[])input.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DecisionTreeMetadata$.$anonfun$buildMetadata$1(x$1)), (ClassTag)ClassTag$.MODULE$.Int()).take(1))).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalArgumentException("DecisionTree requires size of input RDD > 0, but was given by empty one.");
                }));
                Predef$.MODULE$.require(numFeatures > 0, (Function0 & Serializable)() -> "DecisionTree requires number of features > 0, but was given an empty features vector");
                Tuple2 tuple2 = (Tuple2)input.aggregate((Object)new Tuple2.mcJD.sp(0L, 0.0), (Function2 & Serializable)(cw, instance) -> new Tuple2.mcJD.sp(cw._1$mcJ$sp() + 1L, cw._2$mcD$sp() + instance.weight()), (Function2 & Serializable)(cw1, cw2) -> new Tuple2.mcJD.sp(cw1._1$mcJ$sp() + cw2._1$mcJ$sp(), cw1._2$mcD$sp() + cw2._2$mcD$sp()), ClassTag$.MODULE$.apply(Tuple2.class));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long numExamples2 = tuple2._1$mcJ$sp();
                double weightSum2 = tuple2._2$mcD$sp();
                Tuple2.mcJD.sp sp2 = new Tuple2.mcJD.sp(numExamples2, weightSum2);
                numExamples = sp2._1$mcJ$sp();
                weightSum = sp2._2$mcD$sp();
                Enumeration.Value value = strategy.algo();
                Enumeration.Value value2 = Algo$.MODULE$.Classification();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    n2 = strategy.numClasses();
                } else {
                    Enumeration.Value value4 = Algo$.MODULE$.Regression();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) throw new MatchError((Object)value);
                    n2 = 0;
                }
                numClasses = n2;
                int maxPossibleBins = (int)package$.MODULE$.min((long)strategy.maxBins(), numExamples);
                if (maxPossibleBins < strategy.maxBins()) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree reducing maxBins from "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_NUM_BINS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)strategy.maxBins()))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_NUM_POSSIBLE_BINS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)maxPossibleBins))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(= number of training instances)"}))).log((Seq)Nil$.MODULE$))));
                }
                if (strategy.categoricalFeaturesInfo().nonEmpty()) {
                    int maxCategoriesPerFeature = BoxesRunTime.unboxToInt((Object)strategy.categoricalFeaturesInfo().values().max((Ordering)Ordering.Int$.MODULE$));
                    int maxCategory = ((Tuple2)strategy.categoricalFeaturesInfo().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DecisionTreeMetadata$.$anonfun$buildMetadata$7(maxCategoriesPerFeature, x$3))).get())._1$mcI$sp();
                    Predef$.MODULE$.require(maxCategoriesPerFeature <= maxPossibleBins, (Function0 & Serializable)() -> "DecisionTree requires maxBins (= " + maxPossibleBins + ") to be at least as large as the number of values in each categorical feature, but categorical feature " + maxCategory + " has " + maxCategoriesPerFeature + " values. Consider removing this and other categorical features with a large number of values, or add more training examples.");
                }
                unorderedFeatures = new HashSet();
                numBins = (int[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcI.sp & Serializable)() -> maxPossibleBins, (ClassTag)ClassTag$.MODULE$.Int());
                if (numClasses > 2) {
                    int maxCategoriesForUnorderedFeature = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)(maxPossibleBins / 2 + 1)) / package$.MODULE$.log(2.0) + 1.0));
                    strategy.categoricalFeaturesInfo().foreach((Function1 & Serializable)x0$1 -> {
                        DecisionTreeMetadata$.$anonfun$buildMetadata$10(maxCategoriesForUnorderedFeature, unorderedFeatures, numBins, x0$1);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    strategy.categoricalFeaturesInfo().foreach((Function1 & Serializable)x0$2 -> {
                        DecisionTreeMetadata$.$anonfun$buildMetadata$11(numBins, x0$2);
                        return BoxedUnit.UNIT;
                    });
                }
                String string2 = featureSubsetStrategy;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case 3005871: {
                        if (!"auto".equals(string2)) break;
                        if (numTrees == 1) {
                            string = "all";
                        } else {
                            Enumeration.Value value6 = strategy.algo();
                            Enumeration.Value value7 = Algo$.MODULE$.Classification();
                            string = !(value6 != null ? !value6.equals(value7) : value7 != null) ? "sqrt" : "onethird";
                        }
                        break block20;
                    }
                }
                string = featureSubsetStrategy;
            }
            String string3 = _featureSubsetStrategy = string;
            switch (string3 == null ? 0 : string3.hashCode()) {
                case 96673: {
                    if (!"all".equals(string3)) break;
                    n = numFeatures;
                    break block21;
                }
                case 3327342: {
                    if (!"log2".equals(string3)) break;
                    n = package$.MODULE$.max(1, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))));
                    break block21;
                }
                case 3538208: {
                    if (!"sqrt".equals(string3)) break;
                    n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures)));
                    break block21;
                }
                case 2021451457: {
                    if (!"onethird".equals(string3)) break;
                    n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0));
                    break block21;
                }
            }
            Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_featureSubsetStrategy))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 > 0).toOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                int value = BoxesRunTime.unboxToInt((Object)some.value());
                n = package$.MODULE$.min(value, numFeatures);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                Option option2 = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_featureSubsetStrategy))).filter((Function1)(JFunction1.mcZD.sp & Serializable)x$5 -> x$5 > 0.0).filter((Function1)(JFunction1.mcZD.sp & Serializable)x$6 -> x$6 <= 1.0).toOption();
                if (!(option2 instanceof Some)) throw new IllegalArgumentException("Supported values: " + Predef$.MODULE$.wrapRefArray((Object[])TreeEnsembleParams$.MODULE$.supportedFeatureSubsetStrategies()).mkString(", ") + ", (0.0-1.0], [1-n].");
                Some some = (Some)option2;
                double value = BoxesRunTime.unboxToDouble((Object)some.value());
                n = (int)package$.MODULE$.ceil(value * (double)numFeatures);
            }
        }
        int numFeaturesPerNode = n;
        return new DecisionTreeMetadata(numFeatures, numExamples, weightSum, numClasses, BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(numBins).max((Ordering)Ordering.Int$.MODULE$)), strategy.categoricalFeaturesInfo(), (Set<Object>)unorderedFeatures.toSet(), numBins, strategy.impurity(), strategy.quantileCalculationStrategy(), strategy.maxDepth(), strategy.minInstancesPerNode(), strategy.minWeightFractionPerNode(), strategy.minInfoGain(), numTrees, numFeaturesPerNode);
    }

    public DecisionTreeMetadata buildMetadata(RDD<Instance> input, Strategy strategy) {
        return this.buildMetadata(input, strategy, 1, "all");
    }

    public int numUnorderedBins(int arity) {
        return (1 << arity - 1) - 1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DecisionTreeMetadata$.class);
    }

    public static final /* synthetic */ int $anonfun$buildMetadata$1(Instance x$1) {
        return x$1.features().size();
    }

    public static final /* synthetic */ boolean $anonfun$buildMetadata$7(int maxCategoriesPerFeature$1, Tuple2 x$3) {
        return x$3._2$mcI$sp() == maxCategoriesPerFeature$1;
    }

    public static final /* synthetic */ void $anonfun$buildMetadata$10(int maxCategoriesForUnorderedFeature$1, HashSet unorderedFeatures$1, int[] numBins$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int featureIndex = tuple2._1$mcI$sp();
            int numCategories = tuple2._2$mcI$sp();
            if (numCategories > 1) {
                if (numCategories <= maxCategoriesForUnorderedFeature$1) {
                    unorderedFeatures$1.add((Object)BoxesRunTime.boxToInteger((int)featureIndex));
                    numBins$1[featureIndex] = MODULE$.numUnorderedBins(numCategories);
                    return;
                }
                numBins$1[featureIndex] = numCategories;
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$buildMetadata$11(int[] numBins$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int featureIndex = tuple2._1$mcI$sp();
            int numCategories = tuple2._2$mcI$sp();
            if (numCategories > 1) {
                numBins$1[featureIndex] = numCategories;
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private DecisionTreeMetadata$() {
    }
}

