/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002\u0014(\u0001IB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t?\u0002\u0011\t\u0011)A\u0005'\"A\u0011\r\u0001BC\u0002\u0013\u0005!\r\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003d\u0011!)\bA!b\u0001\n\u0003\u0011\u0007\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002\u0002CA\u001d\u0001\u0001&I!a\u000f\t\u000f\u0005-\u0002\u0001\"\u0001\u0002N!9\u00111\u0006\u0001\u0005\u0002\u0005}\u0003bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\tI\u000b\u0001C!\u0003WCq!a1\u0001\t\u0003\t)\rC\u0004\u0002T\u0002!\t!!6\b\u000f\u0005uw\u0005#\u0001\u0002`\u001a1ae\nE\u0001\u0003CDa!_\n\u0005\u0002\u0005M\bbBA{'\u0011%\u0011q\u001f\u0005\b\u0005\u000f\u0019B\u0011\u0002B\u0005\u0011\u001d\u0011Yb\u0005C\u0005\u0005;A\u0011Ba\u000b\u0014#\u0003%IA!\f\t\u000f\t\u00053\u0003\"\u0011\u0003D\u001dA!1J\n\t\u0002\u001d\u0012iE\u0002\u0005\u0003RMA\ta\nB*\u0011\u0019I8\u0004\"\u0001\u0003V!I!qK\u000eC\u0002\u0013%!\u0011\f\u0005\t\u0005?Z\u0002\u0015!\u0003\u0003\\!Q!\u0011M\u000eC\u0002\u0013\u0005qE!\u0017\t\u0011\t\r4\u0004)A\u0005\u00057Bq!!+\u001c\t\u0003\u0011)\u0007C\u0004\u0003Bm!\tA!\u001c\t\u000f\tM4\u0004\"\u0003\u0003v!9!\u0011P\u000e\u0005\n\tm\u0004\"\u0003B@'\u0005\u0005I\u0011\u0002BA\u0005ai\u0015\r\u001e:jq\u001a\u000b7\r^8sSj\fG/[8o\u001b>$W\r\u001c\u0006\u0003Q%\naB]3d_6lWM\u001c3bi&|gN\u0003\u0002+W\u0005)Q\u000e\u001c7jE*\u0011A&L\u0001\u0006gB\f'o\u001b\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0019\u0014hP&\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\tQT(D\u0001<\u0015\ta\u0014&\u0001\u0003vi&d\u0017B\u0001 <\u0005!\u0019\u0016M^3bE2,\u0007C\u0001!I\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002Ec\u00051AH]8pizJ\u0011AN\u0005\u0003\u000fV\nq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\na1+\u001a:jC2L'0\u00192mK*\u0011q)\u000e\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d.\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003!6\u0013q\u0001T8hO&tw-\u0001\u0003sC:\\W#A*\u0011\u0005Q\"\u0016BA+6\u0005\rIe\u000e\u001e\u0015\u0004\u0003]k\u0006C\u0001-\\\u001b\u0005I&B\u0001.,\u0003)\tgN\\8uCRLwN\\\u0005\u00039f\u0013QaU5oG\u0016\f\u0013AX\u0001\u0006a9Bd\u0006M\u0001\u0006e\u0006t7\u000e\t\u0015\u0004\u0005]k\u0016\u0001D;tKJ4U-\u0019;ve\u0016\u001cX#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t17&A\u0002sI\u0012L!\u0001[3\u0003\u0007I#E\t\u0005\u00035UNc\u0017BA66\u0005\u0019!V\u000f\u001d7feA\u0019A'\\8\n\u00059,$!B!se\u0006L\bC\u0001\u001bq\u0013\t\tXG\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0007]k\u0016!D;tKJ4U-\u0019;ve\u0016\u001c\b\u0005K\u0002\u0005/v\u000bq\u0002\u001d:pIV\u001cGOR3biV\u0014Xm\u001d\u0015\u0004\u000b]k\u0016\u0001\u00059s_\u0012,8\r\u001e$fCR,(/Z:!Q\r1q+X\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bmlx0a\u0001\u0011\u0005q\u0004Q\"A\u0014\t\u000bE;\u0001\u0019A*)\u0007u<V\fC\u0003b\u000f\u0001\u00071\rK\u0002\u0000/vCQ!^\u0004A\u0002\rDC!a\u0001X;\"\u001aqaV/\u0002!Y\fG.\u001b3bi\u00164U-\u0019;ve\u0016\u001cHCBA\u0007\u0003'\t9\u0003E\u00025\u0003\u001fI1!!\u00056\u0005\u0011)f.\u001b;\t\u000f\u0005U\u0001\u00021\u0001\u0002\u0018\u0005!a.Y7f!\u0011\tI\"!\t\u000f\t\u0005m\u0011Q\u0004\t\u0003\u0005VJ1!a\b6\u0003\u0019\u0001&/\u001a3fM&!\u00111EA\u0013\u0005\u0019\u0019FO]5oO*\u0019\u0011qD\u001b\t\r\u0005%\u0002\u00021\u0001d\u0003!1W-\u0019;ve\u0016\u001c\u0018a\u00029sK\u0012L7\r\u001e\u000b\u0006_\u0006=\u00121\u0007\u0005\u0007\u0003cI\u0001\u0019A*\u0002\tU\u001cXM\u001d\u0005\u0007\u0003kI\u0001\u0019A*\u0002\u000fA\u0014x\u000eZ;di\"\u001a\u0011bV/\u0002=\r|WO\u001c;BaB\u0014x\u000e\u001f#jgRLgn\u0019;Vg\u0016\u0014\bK]8ek\u000e$H\u0003BA\u001f\u0003\u000b\u0002b\u0001\u000e6\u0002@\u0005}\u0002c\u0001\u001b\u0002B%\u0019\u00111I\u001b\u0003\t1{gn\u001a\u0005\b\u0003\u000fR\u0001\u0019AA%\u00035)8/\u001a:t!J|G-^2ugB!AmZA&!\u0011!$nU*\u0015\t\u0005=\u0013q\u000b\t\u0005I\u001e\f\t\u0006E\u0002}\u0003'J1!!\u0016(\u0005\u0019\u0011\u0016\r^5oO\"9\u0011qI\u0006A\u0002\u0005%\u0003\u0006B\u0006X\u00037\n#!!\u0018\u0002\u000bAr\u0013H\f\u0019\u0015\t\u0005\u0005\u0014\u0011\u000f\t\u0007\u0003G\ni'!\u0015\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nAA[1wC*\u0019\u00111N\u0016\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002p\u0005\u0015$a\u0002&bm\u0006\u0014F\t\u0012\u0005\b\u0003\u000fb\u0001\u0019AA:!!\t\u0019'!\u001e\u0002z\u0005e\u0014\u0002BA<\u0003K\u00121BS1wCB\u000b\u0017N\u001d*E\tB!\u00111PAB\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015\u0001\u00027b]\u001eT!!a\u001a\n\t\u0005\u0015\u0015Q\u0010\u0002\b\u0013:$XmZ3sQ\u0011aq+!#\"\u0005\u0005-\u0015!B\u0019/e9\u0002\u0014!\u0005:fG>lW.\u001a8e!J|G-^2ugR1\u0011\u0011SAJ\u0003+\u0003B\u0001N7\u0002R!1\u0011\u0011G\u0007A\u0002MCa!a&\u000e\u0001\u0004\u0019\u0016a\u00018v[\"\"QbVANC\t\ti*A\u00032]Er\u0003'\u0001\bsK\u000e|W.\\3oIV\u001bXM]:\u0015\r\u0005E\u00151UAS\u0011\u0019\t)D\u0004a\u0001'\"1\u0011q\u0013\bA\u0002MCCAD,\u0002\u001c\u0006!1/\u0019<f)\u0019\ti!!,\u0002:\"9\u0011qV\bA\u0002\u0005E\u0016AA:d!\u0011\t\u0019,!.\u000e\u0003-J1!a.,\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u001d\tYl\u0004a\u0001\u0003/\tA\u0001]1uQ\"\"qbVA`C\t\t\t-A\u00032]Mr\u0003'A\rsK\u000e|W.\\3oIB\u0013x\u000eZ;diN4uN]+tKJ\u001cH\u0003BAd\u0003\u0017\u0004B\u0001Z4\u0002JB)AG[*\u0002\u0012\"1\u0011q\u0013\tA\u0002MCC\u0001E,\u0002P\u0006\u0012\u0011\u0011[\u0001\u0006c9\"d\u0006M\u0001\u001ae\u0016\u001cw.\\7f]\u0012,6/\u001a:t\r>\u0014\bK]8ek\u000e$8\u000f\u0006\u0003\u0002H\u0006]\u0007BBAL#\u0001\u00071\u000b\u000b\u0003\u0012/\u0006=\u0007f\u0001\u0001X;\u0006AR*\u0019;sSb4\u0015m\u0019;pe&T\u0018\r^5p]6{G-\u001a7\u0011\u0005q\u001c2CB\n4\u0003G\fI\u000f\u0005\u0003;\u0003K\\\u0018bAAtw\t1Aj\\1eKJ\u0004B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t)\u0001\u0002j_&\u0019\u0011*!<\u0015\u0005\u0005}\u0017!\u0003:fG>lW.\u001a8e)!\tI0!@\u0003\u0002\t\u0015\u0001\u0003\u0002\u001bn\u0003w\u0004B\u0001\u000e6T_\"1\u0011q`\u000bA\u00021\f1C]3d_6lWM\u001c3U_\u001a+\u0017\r^;sKNDaAa\u0001\u0016\u0001\u0004\u0019\u0017!\u0006:fG>lW.\u001a8eC\ndWMR3biV\u0014Xm\u001d\u0005\u0007\u0003/+\u0002\u0019A*\u0002\u001fI,7m\\7nK:$gi\u001c:BY2$\"Ba\u0003\u0003\u0010\tE!Q\u0003B\r!\u0011!wM!\u0004\u0011\u000bQR7+!?\t\u000bE3\u0002\u0019A*\t\r\tMa\u00031\u0001d\u0003-\u0019(o\u0019$fCR,(/Z:\t\r\t]a\u00031\u0001d\u0003-!7\u000f\u001e$fCR,(/Z:\t\r\u0005]e\u00031\u0001T\u0003!\u0011Gn\\2lS\u001aLHC\u0002B\u0010\u0005K\u00119\u0003\u0005\u0003eO\n\u0005\u0002#\u0002\u001bk\u0005Ga\u0007c\u0001\u001bn'\"1\u0011\u0011F\fA\u0002\rD\u0001B!\u000b\u0018!\u0003\u0005\raU\u0001\nE2|7m[*ju\u0016\f!C\u00197pG.Lg-\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0006\u0016\u0004'\nE2F\u0001B\u001a!\u0011\u0011)D!\u0010\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005i+\u0014\u0002\u0002B \u0005o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0011aw.\u00193\u0015\u000bm\u0014)Ea\u0012\t\u000f\u0005=\u0016\u00041\u0001\u00022\"9\u00111X\rA\u0002\u0005]\u0001\u0006B\rX\u0003\u007f\u000bAbU1wK2{\u0017\r\u001a,2?B\u00022Aa\u0014\u001c\u001b\u0005\u0019\"\u0001D*bm\u0016du.\u00193Wc}\u00034CA\u000e4)\t\u0011i%A\tuQ&\u001chi\u001c:nCR4VM]:j_:,\"Aa\u0017\u0011\t\u0005m$QL\u0005\u0005\u0003G\ti(\u0001\nuQ&\u001chi\u001c:nCR4VM]:j_:\u0004\u0013!\u0004;iSN\u001cE.Y:t\u001d\u0006lW-\u0001\buQ&\u001c8\t\\1tg:\u000bW.\u001a\u0011\u0015\r\u00055!q\rB6\u0011\u0019\u0011I'\ta\u0001w\u0006)Qn\u001c3fY\"9\u00111X\u0011A\u0002\u0005]A#B>\u0003p\tE\u0004bBAXE\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003w\u0013\u0003\u0019AA\f\u0003!)8/\u001a:QCRDG\u0003BA\f\u0005oBq!a/$\u0001\u0004\t9\"A\u0006qe>$Wo\u0019;QCRDG\u0003BA\f\u0005{Bq!a/%\u0001\u0004\t9\"\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0004B!\u00111\u0010BC\u0013\u0011\u00119)! \u0003\r=\u0013'.Z2uQ\u0011\u0019r+a0)\tI9\u0016q\u0018")
public class MatrixFactorizationModel
implements Saveable,
Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MatrixFactorizationModel load(SparkContext sc, String path) {
        return MatrixFactorizationModel$.MODULE$.load(sc, path);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        Predef$.MODULE$.require(((double[])((Tuple2)features.first())._2()).length == this.rank(), (Function0 & Serializable)() -> name + " feature dimension does not match the rank " + this.rank() + ".");
        if (features.partitioner().isEmpty()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor does not have a partitioner. "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FEATURE_NAME$.MODULE$, (Object)name)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Prediction on individual records could be slow."}))).log((Seq)Nil$.MODULE$))));
        }
        StorageLevel storageLevel = features.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor is not cached. "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FEATURE_NAME$.MODULE$, (Object)name)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Prediction could be slow."}))).log((Seq)Nil$.MODULE$))));
            return;
        }
    }

    public double predict(int user, int product) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable)() -> "userId: " + user + " not found in the model");
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable)() -> "productId: " + product + " not found in the model");
        double[] userVector = (double[])userFeatureSeq.head();
        double[] productVector = (double[])productFeatureSeq.head();
        return BLAS$.MODULE$.nativeBLAS().ddot(this.rank(), userVector, 1, productVector, 1);
    }

    private Tuple2<Object, Object> countApproxDistinctUserProduct(RDD<Tuple2<Object, Object>> usersProducts) {
        HyperLogLogPlus zeroCounterUser = new HyperLogLogPlus(4, 0);
        HyperLogLogPlus zeroCounterProduct = new HyperLogLogPlus(4, 0);
        Tuple2 aggregated = (Tuple2)usersProducts.aggregate((Object)new Tuple2((Object)zeroCounterUser, (Object)zeroCounterProduct), (Function2 & Serializable)(hllTuple, v) -> {
            ((HyperLogLogPlus)hllTuple._1()).offer((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()));
            ((HyperLogLogPlus)hllTuple._2()).offer((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()));
            return hllTuple;
        }, (Function2 & Serializable)(h1, h2) -> {
            ((HyperLogLogPlus)h1._1()).addAll((HyperLogLogPlus)h2._1());
            ((HyperLogLogPlus)h1._2()).addAll((HyperLogLogPlus)h2._2());
            return h1;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2.mcJJ.sp(((HyperLogLogPlus)aggregated._1()).cardinality(), ((HyperLogLogPlus)aggregated._2()).cardinality());
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        Tuple2<Object, Object> tuple2 = this.countApproxDistinctUserProduct(usersProducts);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long usersCount = tuple2._1$mcJ$sp();
        long productsCount = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(usersCount, productsCount);
        long usersCount2 = sp2._1$mcJ$sp();
        long productsCount2 = sp2._2$mcJ$sp();
        if (usersCount2 < productsCount2) {
            RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double[] uFeatures = (double[])tuple22._1();
                        int product = tuple22._2$mcI$sp();
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            return RDD$.MODULE$.rddToPairRDDFunctions(users, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        double[] pFeatures = (double[])tuple22._2();
                        if (tuple23 != null) {
                            int user = tuple23._1$mcI$sp();
                            double[] uFeatures = (double[])tuple23._2();
                            return new Rating(user, product, BLAS$.MODULE$.nativeBLAS().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Rating.class));
        }
        RDD products = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts.map((Function1 & Serializable)x$2 -> x$2.swap$mcII$sp(), ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int product = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    double[] pFeatures = (double[])tuple22._1();
                    int user = tuple22._2$mcI$sp();
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)pFeatures));
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(products, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.userFeatures()).map((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                int user = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    double[] uFeatures = (double[])tuple22._2();
                    if (tuple23 != null) {
                        int product = tuple23._1$mcI$sp();
                        double[] pFeatures = (double[])tuple23._2();
                        return new Rating(user, product, BLAS$.MODULE$.nativeBLAS().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Rating.class));
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable)() -> "userId: " + user + " not found in the model");
        return (Rating[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])userFeatureSeq.head(), this.productFeatures(), num)), (Function1 & Serializable)t -> new Rating(user, t._1$mcI$sp(), t._2$mcD$sp()), ClassTag$.MODULE$.apply(Rating.class));
    }

    public Rating[] recommendUsers(int product, int num) {
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable)() -> "productId: " + product + " not found in the model");
        return (Rating[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])productFeatureSeq.head(), this.userFeatures(), num)), (Function1 & Serializable)t -> new Rating(t._1$mcI$sp(), product, t._2$mcD$sp()), ClassTag$.MODULE$.apply(Rating.class));
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.userFeatures(), this.productFeatures(), num).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int user = tuple2._1$mcI$sp();
                Tuple2[] top = (Tuple2[])tuple2._2();
                Rating[] ratings = (Rating[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])top), (Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int product = tuple2._1$mcI$sp();
                        double rating = tuple2._2$mcD$sp();
                        return new Rating(user, product, rating);
                    }
                    throw new MatchError((Object)tuple2);
                }, ClassTag$.MODULE$.apply(Rating.class));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)ratings);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.productFeatures(), this.userFeatures(), num).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int product = tuple2._1$mcI$sp();
                Tuple2[] top = (Tuple2[])tuple2._2();
                Rating[] ratings = (Rating[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])top), (Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int user = tuple2._1$mcI$sp();
                        double rating = tuple2._2$mcD$sp();
                        return new Rating(user, product, rating);
                    }
                    throw new MatchError((Object)tuple2);
                }, ClassTag$.MODULE$.apply(Rating.class));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)ratings);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
    }
}

