/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.zookeeper;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import org.apache.twill.internal.zookeeper.RewatchOnExpireWatcher;
import org.apache.twill.zookeeper.ForwardingZKClient;
import org.apache.twill.zookeeper.NodeChildren;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public final class RewatchOnExpireZKClient
extends ForwardingZKClient {
    public RewatchOnExpireZKClient(ZKClient delegate) {
        super(delegate);
    }

    @Override
    public OperationFuture<Stat> exists(String path, Watcher watcher) {
        if (watcher == null) {
            return super.exists(path, null);
        }
        final RewatchOnExpireWatcher wrappedWatcher = new RewatchOnExpireWatcher(this, RewatchOnExpireWatcher.ActionType.EXISTS, path, watcher);
        OperationFuture<Stat> result = super.exists(path, wrappedWatcher);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<Stat>(){

            public void onSuccess(Stat result) {
                wrappedWatcher.setLastResult(result);
            }

            public void onFailure(Throwable t) {
            }
        });
        return result;
    }

    @Override
    public OperationFuture<NodeChildren> getChildren(String path, Watcher watcher) {
        if (watcher == null) {
            return super.getChildren(path, null);
        }
        final RewatchOnExpireWatcher wrappedWatcher = new RewatchOnExpireWatcher(this, RewatchOnExpireWatcher.ActionType.CHILDREN, path, watcher);
        OperationFuture<NodeChildren> result = super.getChildren(path, wrappedWatcher);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<NodeChildren>(){

            public void onSuccess(NodeChildren result) {
                wrappedWatcher.setLastResult(result);
            }

            public void onFailure(Throwable t) {
            }
        });
        return result;
    }

    @Override
    public OperationFuture<NodeData> getData(String path, Watcher watcher) {
        if (watcher == null) {
            return super.getData(path, null);
        }
        final RewatchOnExpireWatcher wrappedWatcher = new RewatchOnExpireWatcher(this, RewatchOnExpireWatcher.ActionType.DATA, path, watcher);
        OperationFuture<NodeData> result = super.getData(path, wrappedWatcher);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<NodeData>(){

            public void onSuccess(NodeData result) {
                wrappedWatcher.setLastResult(result);
            }

            public void onFailure(Throwable t) {
            }
        });
        return result;
    }
}

