/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AlgorithmSuite;
import org.apache.ws.security.components.crypto.AlgorithmSuiteValidator;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog(SAMLTokenProcessor.class);
    private XMLSignatureFactory signatureFactory;

    public SAMLTokenProcessor() {
        try {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
    }

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        String id;
        Element foundElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found SAML Assertion element");
        }
        Validator validator = data.getValidator(new QName(elem.getNamespaceURI(), elem.getLocalName()));
        AssertionWrapper samlAssertion = new AssertionWrapper(elem);
        XMLSignature xmlSignature = this.verifySignatureKeysAndAlgorithms(samlAssertion, data, wsDocInfo);
        List<WSDataRef> dataRefs = this.createDataRefs(elem, samlAssertion, xmlSignature);
        Credential credential = this.handleSAMLToken(samlAssertion, data, validator, wsDocInfo);
        samlAssertion = credential.getAssertion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SAML Assertion issuer " + samlAssertion.getIssuerString()));
            log.debug((Object)DOM2Writer.nodeToString(elem));
        }
        if (elem.equals(foundElement = wsDocInfo.getTokenElement(id = samlAssertion.getId()))) {
            WSSecurityEngineResult result = wsDocInfo.getResult(id);
            return Collections.singletonList(result);
        }
        if (foundElement != null) {
            throw new WSSecurityException(4, "duplicateError");
        }
        wsDocInfo.addTokenElement(elem);
        WSSecurityEngineResult result = null;
        if (samlAssertion.isSigned()) {
            result = new WSSecurityEngineResult(16, samlAssertion);
            result.put("data-ref-uris", dataRefs);
        } else {
            result = new WSSecurityEngineResult(8, samlAssertion);
        }
        if (!"".equals(id)) {
            result.put("id", id);
        }
        if (validator != null) {
            result.put("validated-token", Boolean.TRUE);
            if (credential.getTransformedToken() != null) {
                result.put("transformed-token", credential.getTransformedToken());
                if (credential.getPrincipal() != null) {
                    result.put("principal", credential.getPrincipal());
                } else {
                    SAMLTokenPrincipal samlPrincipal = new SAMLTokenPrincipal(credential.getTransformedToken());
                    result.put("principal", samlPrincipal);
                }
            } else if (credential.getPrincipal() != null) {
                result.put("principal", credential.getPrincipal());
            } else {
                result.put("principal", new SAMLTokenPrincipal(samlAssertion));
            }
            result.put("subject", credential.getSubject());
        }
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    public Credential handleSAMLToken(AssertionWrapper samlAssertion, RequestData data, Validator validator, WSDocInfo docInfo) throws WSSecurityException {
        samlAssertion.parseHOKSubject(data, docInfo);
        Credential credential = new Credential();
        credential.setAssertion(samlAssertion);
        if (validator != null) {
            return validator.validate(credential, data);
        }
        return credential;
    }

    private XMLSignature verifySignatureKeysAndAlgorithms(AssertionWrapper samlAssertion, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (samlAssertion.isSigned()) {
            XMLSignature xmlSignature;
            Signature sig = samlAssertion.getSignature();
            KeyInfo keyInfo = sig.getKeyInfo();
            if (keyInfo == null) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
            }
            SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo(keyInfo.getDOM(), data, wsDocInfo, data.getWssConfig().isWsiBSPCompliant());
            PublicKey key = null;
            if (samlKeyInfo.getCerts() != null && samlKeyInfo.getCerts()[0] != null) {
                key = samlKeyInfo.getCerts()[0].getPublicKey();
            } else if (samlKeyInfo.getPublicKey() != null) {
                key = samlKeyInfo.getPublicKey();
            } else {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
            }
            DOMValidateContext context = new DOMValidateContext(key, (Node)sig.getDOM());
            context.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.TRUE);
            context.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
            try {
                xmlSignature = this.signatureFactory.unmarshalXMLSignature(context);
            }
            catch (MarshalException ex) {
                throw new WSSecurityException(6, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"}, ex);
            }
            AlgorithmSuite algorithmSuite = data.getSamlAlgorithmSuite();
            if (algorithmSuite != null) {
                AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
                algorithmSuiteValidator.checkSignatureAlgorithms(xmlSignature);
                algorithmSuiteValidator.checkAsymmetricKeyLength(key);
            }
            samlAssertion.verifySignature(samlKeyInfo);
            return xmlSignature;
        }
        return null;
    }

    private List<WSDataRef> createDataRefs(Element token, AssertionWrapper samlAssertion, XMLSignature xmlSignature) {
        if (xmlSignature == null) {
            return null;
        }
        ArrayList<WSDataRef> protectedRefs = new ArrayList<WSDataRef>();
        String signatureMethod = xmlSignature.getSignedInfo().getSignatureMethod().getAlgorithm();
        for (Reference refObject : xmlSignature.getSignedInfo().getReferences()) {
            Reference reference = refObject;
            if (!"".equals(reference.getURI()) && !reference.getURI().equals(samlAssertion.getId()) && !reference.getURI().equals("#" + samlAssertion.getId())) continue;
            WSDataRef ref = new WSDataRef();
            ref.setWsuId(reference.getURI());
            ref.setProtectedElement(token);
            ref.setAlgorithm(signatureMethod);
            ref.setDigestAlgorithm(reference.getDigestMethod().getAlgorithm());
            List<Transform> transforms = reference.getTransforms();
            ArrayList<String> transformAlgorithms = new ArrayList<String>(transforms.size());
            for (Transform transform : transforms) {
                transformAlgorithms.add(transform.getAlgorithm());
            }
            ref.setTransformAlgorithms(transformAlgorithms);
            ref.setXpath(ReferenceListProcessor.getXPath(token));
            protectedRefs.add(ref);
        }
        return protectedRefs;
    }
}

