/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.data.Index;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.MethodInvocationResultExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractObjectArrayAssert<S extends AbstractObjectArrayAssert<S, T>, T>
extends AbstractAssert<S, T[]>
implements IndexedObjectEnumerableAssert<AbstractObjectArrayAssert<S, T>, T>,
ArraySortedAssert<AbstractObjectArrayAssert<S, T>, T> {
    @VisibleForTesting
    ObjectArrays arrays = ObjectArrays.instance();

    protected AbstractObjectArrayAssert(T[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (Object[])this.actual, expected);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S contains(T ... values) {
        this.arrays.assertContains(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsOnly(T ... values) {
        this.arrays.assertContainsOnly(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsOnlyOnce(T ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsExactly(T ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsSequence(T ... sequence) {
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, sequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsSubsequence(T ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (Object[])this.actual, subsequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S contains(T value, Index index) {
        this.arrays.assertContains(this.info, (Object[])this.actual, value, index);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotContain(T value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, value, index);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotContain(T ... values) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S startsWith(T ... sequence) {
        this.arrays.assertStartsWith(this.info, (Object[])this.actual, sequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S endsWith(T ... sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, sequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsNull() {
        this.arrays.assertContainsNull(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotContainNull() {
        this.arrays.assertDoesNotContainNull(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S are(Condition<? super T> condition) {
        this.arrays.assertAre(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areNot(Condition<? super T> condition) {
        this.arrays.assertAreNot(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S have(Condition<? super T> condition) {
        this.arrays.assertHave(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doNotHave(Condition<? super T> condition) {
        this.arrays.assertDoNotHave(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtLeast(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtMost(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areExactly(int times, Condition<? super T> condition) {
        this.arrays.assertAreExactly(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S haveAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S haveAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S haveExactly(int times, Condition<? super T> condition) {
        this.arrays.assertHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super T> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (Object[])this.actual, comparator);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsAll(Iterable<? extends T> iterable) {
        this.arrays.assertContainsAll(this.info, (Object[])this.actual, iterable);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> customComparator) {
        this.arrays = new ObjectArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = ObjectArrays.instance();
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    public ObjectArrayAssert<Object> extracting(String fieldOrProperty) {
        Object[] values = FieldsOrPropertiesExtractor.extract(fieldOrProperty, (Object[])this.actual);
        return new ObjectArrayAssert<Object>(values);
    }

    public <P> ObjectArrayAssert<P> extracting(String fieldOrProperty, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract(fieldOrProperty, (Object[])this.actual);
        return new ObjectArrayAssert<Object>(values);
    }

    public ObjectArrayAssert<Tuple> extracting(String ... fieldsOrProperties) {
        Tuple[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, fieldsOrProperties);
        return new ObjectArrayAssert<Tuple>(values);
    }

    public ObjectArrayAssert<Object> extractingResultOf(String method) {
        Object[] values = MethodInvocationResultExtractor.extractResultOf(method, (Object[])this.actual);
        return new ObjectArrayAssert<Object>(values);
    }

    public <P> ObjectArrayAssert<P> extractingResultOf(String method, Class<P> extractingType) {
        Object[] values = MethodInvocationResultExtractor.extractResultOf(method, (Object[])this.actual);
        return new ObjectArrayAssert<Object>(values);
    }
}

