/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.util.ArrayWrapperList;
import org.assertj.core.util.Iterables;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.FieldUtils;
import org.assertj.core.util.introspection.IntrospectionError;

public class FieldSupport {
    private static final String SEPARATOR = ".";
    private static final FieldSupport INSTANCE = new FieldSupport();

    public static FieldSupport instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    FieldSupport() {
    }

    public <T> List<T> fieldValues(String fieldName, Class<T> fieldClass, Iterable<?> target) {
        List<?> cleanedUp = Iterables.nonNullElementsIn(target);
        if (Iterables.isNullOrEmpty(cleanedUp)) {
            return Collections.emptyList();
        }
        if (this.isNestedField(fieldName)) {
            String firstFieldName = this.popFieldNameFrom(fieldName);
            List<Object> fieldValues = this.fieldValues(firstFieldName, Object.class, cleanedUp);
            return this.fieldValues(this.nextFieldNameFrom(fieldName), fieldClass, fieldValues);
        }
        return this.simpleFieldValues(fieldName, fieldClass, cleanedUp);
    }

    public List<Object> fieldValues(String fieldName, Iterable<?> target) {
        return this.fieldValues(fieldName, Object.class, target);
    }

    public <T> List<T> fieldValues(String fieldName, Class<T> fieldClass, Object[] target) {
        return this.fieldValues(fieldName, fieldClass, ArrayWrapperList.wrap(target));
    }

    public List<Object> fieldValues(String fieldName, Object[] target) {
        return this.fieldValues(fieldName, Object.class, ArrayWrapperList.wrap(target));
    }

    public static <T> T fieldValueOf(String fieldName, Object target, Class<T> clazz) {
        return FieldSupport.instance().fieldValue(fieldName, clazz, target);
    }

    private <T> List<T> simpleFieldValues(String fieldName, Class<T> clazz, Iterable<?> target) {
        ArrayList<T> fieldValues = new ArrayList<T>();
        for (Object e : target) {
            fieldValues.add(this.fieldValue(fieldName, clazz, e));
        }
        return Collections.unmodifiableList(fieldValues);
    }

    private String popFieldNameFrom(String fieldNameChain) {
        if (!this.isNestedField(fieldNameChain)) {
            return fieldNameChain;
        }
        return fieldNameChain.substring(0, fieldNameChain.indexOf(SEPARATOR));
    }

    private String nextFieldNameFrom(String fieldNameChain) {
        if (!this.isNestedField(fieldNameChain)) {
            return "";
        }
        return fieldNameChain.substring(fieldNameChain.indexOf(SEPARATOR) + 1);
    }

    private boolean isNestedField(String fieldName) {
        return fieldName.contains(SEPARATOR) && !fieldName.startsWith(SEPARATOR) && !fieldName.endsWith(SEPARATOR);
    }

    public <T> T fieldValue(String fieldName, Class<T> clazz, Object target) {
        try {
            Object readField = FieldUtils.readField(target, fieldName);
            return clazz.cast(readField);
        }
        catch (ClassCastException e) {
            String msg = String.format("Unable to obtain the value of the field <'%s'> from <%s> - wrong field type specified <%s>", fieldName, target, clazz);
            throw new IntrospectionError(msg, e);
        }
        catch (IllegalAccessException iae) {
            String msg = String.format("Unable to obtain the value of the field <'%s'> from <%s>, check that field is public.", fieldName, target);
            throw new IntrospectionError(msg, iae);
        }
        catch (Throwable unexpected) {
            String msg = String.format("Unable to obtain the value of the field <'%s'> from <%s>", fieldName, target);
            throw new IntrospectionError(msg, unexpected);
        }
    }

    public <T> T fieldValueOf(String fieldName, Class<T> clazz, Object target) {
        if (target == null) {
            return null;
        }
        if (this.isNestedField(fieldName)) {
            String firstFieldName = this.popFieldNameFrom(fieldName);
            Object fieldValue = this.fieldValue(firstFieldName, Object.class, target);
            return this.fieldValueOf(this.nextFieldNameFrom(fieldName), clazz, fieldValue);
        }
        return this.fieldValue(fieldName, clazz, target);
    }
}

