/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.error.ConstructorInvoker;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class ShouldBeEqual
implements AssertionErrorFactory {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "\nExpecting:\n <%s>\nto be equal to:\n <%s>\nbut was not.";
    private static final String EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR = "\nExpecting:\n <%s>\nto be equal to:\n <%s>\n%s but was not.";
    private static final Class<?>[] MSG_ARG_TYPES = new Class[]{String.class, String.class, String.class};
    protected final Object actual;
    protected final Object expected;
    @VisibleForTesting
    final MessageFormatter messageFormatter = MessageFormatter.instance();
    private final ComparisonStrategy comparisonStrategy;
    private Representation representation;
    @VisibleForTesting
    ConstructorInvoker constructorInvoker = new ConstructorInvoker();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, Representation representation) {
        return new ShouldBeEqual(actual, expected, StandardComparisonStrategy.instance(), representation);
    }

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Representation representation) {
        return new ShouldBeEqual(actual, expected, comparisonStrategy, representation);
    }

    @VisibleForTesting
    ShouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Representation representation) {
        this.actual = actual;
        this.expected = expected;
        this.comparisonStrategy = comparisonStrategy;
        this.representation = representation;
    }

    @Override
    public AssertionError newAssertionError(Description description, Representation representation) {
        AssertionError error;
        if (this.actualAndExpectedHaveSameStringRepresentation()) {
            return Failures.instance().failure(this.defaultDetailedErrorMessage(description, representation));
        }
        if (this.isJUnitComparisonFailureRelevant() && (error = this.comparisonFailure(description)) != null) {
            return error;
        }
        return Failures.instance().failure(this.defaultErrorMessage(description, representation));
    }

    private boolean isJUnitComparisonFailureRelevant() {
        return !(this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy);
    }

    private boolean actualAndExpectedHaveSameStringRepresentation() {
        return Objects.areEqual(this.representation.toStringOf(this.actual), this.representation.toStringOf(this.expected));
    }

    private String defaultErrorMessage(Description description, Representation representation) {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.actual, this.expected, this.comparisonStrategy);
        }
        return this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE, this.expected, this.actual);
    }

    private String defaultDetailedErrorMessage(Description description, Representation representation) {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.detailedActual(), this.detailedExpected(), this.comparisonStrategy);
        }
        return this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE, this.detailedExpected(), this.detailedActual());
    }

    private AssertionError comparisonFailure(Description description) {
        try {
            AssertionError comparisonFailure = this.newComparisonFailure(this.descriptionFormatter.format(description).trim());
            Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(comparisonFailure);
            return comparisonFailure;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private AssertionError newComparisonFailure(String description) throws Exception {
        Object o = this.constructorInvoker.newInstance("org.junit.ComparisonFailure", MSG_ARG_TYPES, this.msgArgs(description));
        if (o instanceof AssertionError) {
            return (AssertionError)o;
        }
        return null;
    }

    private Object[] msgArgs(String description) {
        return Arrays.array(description, this.representation.toStringOf(this.expected), this.representation.toStringOf(this.actual));
    }

    private String detailedToStringOf(Object obj) {
        return this.representation.toStringOf(obj) + " (" + obj.getClass().getSimpleName() + "@" + Integer.toHexString(obj.hashCode()) + ")";
    }

    private String detailedActual() {
        return this.detailedToStringOf(this.actual);
    }

    private String detailedExpected() {
        return this.detailedToStringOf(this.expected);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ShouldBeEqual other = (ShouldBeEqual)o;
        if (!Objects.areEqual(this.actual, other.actual)) {
            return false;
        }
        return Objects.areEqual(this.expected, other.expected);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.actual);
        result = 31 * result + Objects.hashCodeFor(this.expected);
        return result;
    }
}

