/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.internal.FieldComparisonStrategy;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public class OnFieldsComparisonStrategy
extends FieldComparisonStrategy {
    private String[] fields;

    public OnFieldsComparisonStrategy(String ... fields) {
        this.fields = fields;
    }

    @Override
    protected boolean areFieldsEqual(Object actual, Object other) {
        return Objects.instance().areEqualToComparingOnlyGivenFields(actual, other, this.fields);
    }

    @VisibleForTesting
    public String[] getFields() {
        return this.fields;
    }

    @Override
    public String asText() {
        return "when comparing elements field by field on the following fields only : " + this.fieldsAsText() + "\n";
    }

    private String fieldsAsText() {
        return Strings.join(this.fields).with(", ");
    }
}

