/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeEqualIgnoringCase;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldContainCharSequenceOnlyOnce;
import org.assertj.core.error.ShouldContainCharSequenceSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldMatchPattern;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContainCharSequence;
import org.assertj.core.error.ShouldNotMatchPattern;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.xml.XmlStringPrettyFormatter;

public class Strings {
    private static final Strings INSTANCE = new Strings();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Strings instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Strings() {
        this(StandardComparisonStrategy.instance());
    }

    public Strings(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertNullOrEmpty(AssertionInfo info, CharSequence actual) {
        if (actual == null || !Strings.hasContents(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
    }

    public void assertEmpty(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (!Strings.hasContents(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
    }

    public void assertNotEmpty(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (Strings.hasContents(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
    }

    private static boolean hasContents(CharSequence s) {
        return s.length() > 0;
    }

    public void assertHasSize(AssertionInfo info, CharSequence actual, int expectedSize) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizes(actual, actual.length(), expectedSize, info);
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, Iterable<?> other) {
        this.assertNotNull(info, actual);
        CommonValidations.hasSameSizeAsCheck(info, (Object)actual, other, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, Object array) {
        Objects.instance().assertNotNull(info, actual);
        Arrays.assertIsArray(info, array);
        CommonValidations.hasSameSizeAsCheck(info, (Object)actual, array, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, CharSequence other) {
        Objects.instance().assertNotNull(info, actual);
        CommonValidations.checkOtherIsNotNull(other, "CharSequence or String");
        CommonValidations.checkSameSizes(info, actual, actual.length(), other.length());
    }

    public void assertContains(AssertionInfo info, CharSequence actual, CharSequence ... values) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(values);
        this.checkIsNotEmpty(values);
        this.checkCharSequenceIsNotNull(values[0]);
        LinkedHashSet<CharSequence> notFound = new LinkedHashSet<CharSequence>();
        for (CharSequence value : values) {
            if (this.stringContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            return;
        }
        if (notFound.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    private void checkIsNotNull(CharSequence ... values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private void checkIsNotEmpty(CharSequence ... values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private boolean stringContains(CharSequence actual, CharSequence sequence) {
        return this.comparisonStrategy.stringContains(actual.toString(), sequence.toString());
    }

    public void assertContainsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (actual.toString().toLowerCase().contains(sequence.toString().toLowerCase())) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContainIgnoringCase(actual, sequence));
    }

    public void assertDoesNotContain(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!this.stringContains(actual, sequence)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContain(actual, sequence, this.comparisonStrategy));
    }

    private void checkCharSequenceIsNotNull(CharSequence sequence) {
        if (sequence == null) {
            throw new NullPointerException("The char sequence to look for should not be null");
        }
    }

    public void assertEqualsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (this.areEqualIgnoringCase(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualIgnoringCase.shouldBeEqual(actual, expected));
    }

    private boolean areEqualIgnoringCase(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        return actual.toString().equalsIgnoreCase(expected.toString());
    }

    public void assertContainsOnlyOnce(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        int sequenceOccurencesInActual = this.countOccurences(sequence, actual);
        if (sequenceOccurencesInActual == 1) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequenceOnlyOnce.shouldContainOnlyOnce(actual, sequence, sequenceOccurencesInActual, this.comparisonStrategy));
    }

    private int countOccurences(CharSequence sequenceToSearch, CharSequence actual) {
        String strToSearch = sequenceToSearch.toString();
        String strActual = actual.toString();
        int occurences = 0;
        for (int i = 0; i <= strActual.length() - strToSearch.length(); ++i) {
            if (!this.comparisonStrategy.areEqual(strActual.substring(i, i + sequenceToSearch.length()), strToSearch)) continue;
            ++occurences;
        }
        return occurences;
    }

    public void assertStartsWith(AssertionInfo info, CharSequence actual, CharSequence prefix) {
        if (prefix == null) {
            throw new NullPointerException("The given prefix should not be null");
        }
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy.stringStartsWith(actual.toString(), prefix.toString())) {
            return;
        }
        throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual, prefix, this.comparisonStrategy));
    }

    public void assertEndsWith(AssertionInfo info, CharSequence actual, CharSequence suffix) {
        if (suffix == null) {
            throw new NullPointerException("The given suffix should not be null");
        }
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy.stringEndsWith(actual.toString(), suffix.toString())) {
            return;
        }
        throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual, suffix, this.comparisonStrategy));
    }

    public void assertMatches(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        if (Pattern.matches(regex.toString(), actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, regex));
    }

    public void assertDoesNotMatch(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        if (!Pattern.matches(regex.toString(), actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, regex));
    }

    private void checkRegexIsNotNull(CharSequence regex) {
        if (regex == null) {
            throw this.patternToMatchIsNull();
        }
    }

    public void assertMatches(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        if (pattern.matcher(actual).matches()) {
            return;
        }
        throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, pattern.pattern()));
    }

    public void assertDoesNotMatch(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        if (actual == null || !pattern.matcher(actual).matches()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, pattern.pattern()));
    }

    private void checkIsNotNull(Pattern pattern) {
        if (pattern == null) {
            throw this.patternToMatchIsNull();
        }
    }

    private NullPointerException patternToMatchIsNull() {
        return new NullPointerException("The regular expression pattern to match should not be null");
    }

    private void assertNotNull(AssertionInfo info, CharSequence actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    public void assertContainsSequence(AssertionInfo info, CharSequence actual, CharSequence[] values) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(values);
        this.checkIsNotEmpty(values);
        this.checkCharSequenceIsNotNull(values[0]);
        LinkedHashSet<CharSequence> notFound = new LinkedHashSet<CharSequence>();
        for (CharSequence value : values) {
            if (this.stringContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            if (values.length == 1) {
                return;
            }
            String strActual = actual.toString();
            for (int i = 1; i < values.length; ++i) {
                if (strActual.indexOf(values[i - 1].toString()) <= strActual.indexOf(values[i].toString())) continue;
                throw this.failures.failure(info, ShouldContainCharSequenceSequence.shouldContainSequence(actual, values, i - 1, this.comparisonStrategy));
            }
            return;
        }
        if (notFound.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    public void assertXmlEqualsTo(AssertionInfo info, CharSequence actualXml, CharSequence expectedXml) {
        this.checkCharSequenceIsNotNull(expectedXml);
        this.assertNotNull(info, actualXml);
        String formattedActualXml = XmlStringPrettyFormatter.xmlPrettyFormat(actualXml.toString());
        String formattedExpectedXml = XmlStringPrettyFormatter.xmlPrettyFormat(expectedXml.toString());
        if (!this.comparisonStrategy.areEqual(formattedActualXml, formattedExpectedXml)) {
            throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(formattedActualXml, formattedExpectedXml, this.comparisonStrategy, info.representation()));
        }
    }
}

