/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.IntrospectionError;

public class FieldByFieldComparator
implements Comparator<Object> {
    protected final Map<String, Comparator<?>> comparatorsByPropertyOrField;
    protected final TypeComparators comparatorsByType;

    public FieldByFieldComparator(Map<String, Comparator<?>> comparatorsByPropertyOrField, TypeComparators typeComparators) {
        this.comparatorsByPropertyOrField = comparatorsByPropertyOrField == null ? new TreeMap() : comparatorsByPropertyOrField;
        this.comparatorsByType = FieldByFieldComparator.isNullOrEmpty(typeComparators) ? TypeComparators.defaultTypeComparators() : typeComparators;
    }

    public FieldByFieldComparator() {
        this(new TreeMap(), TypeComparators.defaultTypeComparators());
    }

    @Override
    public int compare(Object actual, Object other) {
        if (actual == null && other == null) {
            return 0;
        }
        if (actual == null || other == null) {
            return -1;
        }
        return this.areEqual(actual, other) ? 0 : -1;
    }

    protected boolean areEqual(Object actual, Object other) {
        try {
            return Objects.instance().areEqualToIgnoringGivenFields(actual, other, this.comparatorsByPropertyOrField, this.comparatorsByType, new String[0]);
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    public String toString() {
        return this.description() + this.describeUsedComparators();
    }

    protected String description() {
        return "field/property by field/property comparator on all fields/properties";
    }

    protected String describeUsedComparators() {
        if (this.comparatorsByPropertyOrField.isEmpty()) {
            return String.format("%nComparators used:%n%s", this.describeFieldComparatorsByType());
        }
        return String.format("%nComparators used:%n%s%n%s", this.describeFieldComparatorsByName(), this.describeFieldComparatorsByType());
    }

    protected String describeFieldComparatorsByType() {
        return String.format("- for elements fields (by type): %s", this.comparatorsByType);
    }

    protected String describeFieldComparatorsByName() {
        if (this.comparatorsByPropertyOrField.isEmpty()) {
            return "";
        }
        List fieldComparatorsDescription = this.comparatorsByPropertyOrField.entrySet().stream().map(FieldByFieldComparator::formatFieldComparator).collect(Collectors.toList());
        return String.format("- for elements fields (by name): {%s}", Strings.join(fieldComparatorsDescription).with(", "));
    }

    private static String formatFieldComparator(Map.Entry<String, Comparator<?>> next) {
        return next.getKey() + " -> " + next.getValue();
    }

    private static boolean isNullOrEmpty(TypeComparators comparatorByType) {
        return comparatorByType == null || comparatorByType.isEmpty();
    }
}

