/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.OptionalInt;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;
import org.assertj.core.internal.Integers;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractOptionalIntAssert<S extends AbstractOptionalIntAssert<S>>
extends AbstractAssert<S, OptionalInt> {
    @VisibleForTesting
    Integers integers = Integers.instance();

    protected AbstractOptionalIntAssert(OptionalInt actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isPresent() {
        this.isNotNull();
        if (!((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
        return (S)((AbstractOptionalIntAssert)this.myself);
    }

    public S isNotPresent() {
        return this.isEmpty();
    }

    public S isEmpty() {
        this.isNotNull();
        if (((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((OptionalInt)this.actual));
        }
        return (S)((AbstractOptionalIntAssert)this.myself);
    }

    public S isNotEmpty() {
        return this.isPresent();
    }

    public S hasValue(int expectedValue) {
        this.isNotNull();
        if (!((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (expectedValue != ((OptionalInt)this.actual).getAsInt()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain((OptionalInt)this.actual, expectedValue));
        }
        return (S)((AbstractOptionalIntAssert)this.myself);
    }
}

