/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHavePksNames;
import org.assertj.db.error.ShouldHavePksValues;
import org.assertj.db.type.Change;
import org.assertj.db.type.Value;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.util.Values;

public class AssertionsOnPrimaryKey {
    private static final Failures failures = Failures.instance();

    private AssertionsOnPrimaryKey() {
    }

    public static <A extends AbstractAssert<?>> A hasPksNames(A assertion, WritableAssertionInfo info, Change change, LetterCase primaryKeyLetterCase, String ... names) {
        if (names == null) {
            throw new NullPointerException("Columns names must be not null");
        }
        List<String> pksNameList = change.getPksNameList();
        ArrayList<String> pksList = new ArrayList<String>(pksNameList);
        pksList.sort(primaryKeyLetterCase);
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException("Column name must be not null");
            }
            namesList.add(name);
        }
        namesList.sort(primaryKeyLetterCase);
        Iterator namesIterator = namesList.iterator();
        Iterator pksIterator = pksList.iterator();
        while (namesIterator.hasNext() && pksIterator.hasNext()) {
            String pk;
            String name = (String)namesIterator.next();
            if (primaryKeyLetterCase.isEqual(name, pk = (String)pksIterator.next())) continue;
            String[] pksNames = pksNameList.toArray(new String[0]);
            throw failures.failure((AssertionInfo)info, ShouldHavePksNames.shouldHavePksNames(pksNames, names));
        }
        if (namesIterator.hasNext() || pksIterator.hasNext()) {
            String[] pksNames = pksNameList.toArray(new String[0]);
            throw failures.failure((AssertionInfo)info, ShouldHavePksNames.shouldHavePksNames(pksNames, names));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasPksValues(A assertion, WritableAssertionInfo info, Change change, Object ... values) {
        List<Value> pksValueList = change.getPksValueList();
        Value[] pksValues = pksValueList.toArray(new Value[0]);
        if (values.length != pksValues.length) {
            Object[] representationsValues = Values.getRepresentationsFromValuesInFrontOfExpected(pksValues, values);
            throw failures.failure((AssertionInfo)info, ShouldHavePksValues.shouldHavePksValues(representationsValues, values));
        }
        int index = 0;
        for (Value pkValue : pksValueList) {
            Object value;
            if (!Values.areEqual(pkValue, value = values[index])) {
                Object[] representationsValues = Values.getRepresentationsFromValuesInFrontOfExpected(pksValues, values);
                throw failures.failure((AssertionInfo)info, ShouldHavePksValues.shouldHavePksValues(representationsValues, values));
            }
            ++index;
        }
        return assertion;
    }
}

