/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.error.ShouldBeCompatible;
import org.assertj.db.error.ShouldBeEqual;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnRowEquality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnRowEquality() {
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Object ... expected) {
        AssertionsOnNumberOfColumns.hasNumberOfColumns(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            Object object;
            if (!value.isComparisonPossible(object = expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeCompatible.shouldBeCompatible(value, object));
            }
            if (!Values.areEqual(value, expected[index])) {
                if (value.getValueType() == ValueType.BYTES) {
                    throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index));
                }
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }
}

