/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnValueType;
import org.assertj.db.error.ShouldBeGreater;
import org.assertj.db.error.ShouldBeGreaterOrEqual;
import org.assertj.db.error.ShouldBeLess;
import org.assertj.db.error.ShouldBeLessOrEqual;
import org.assertj.db.type.Value;
import org.assertj.db.util.Values;

public class AssertionsOnValueComparison {
    private static final Failures failures = Failures.instance();

    private AssertionsOnValueComparison() {
    }

    public static <A extends AbstractAssert<?>> A isGreaterThan(A assertion, WritableAssertionInfo info, Value value, Number expected) {
        AssertionsOnValueType.isNumber(assertion, info, value);
        if (Values.compare(value, expected) > 0) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeGreater.shouldBeGreater(value, expected));
    }

    public static <A extends AbstractAssert<?>> A isLessThan(A assertion, WritableAssertionInfo info, Value value, Number expected) {
        AssertionsOnValueType.isNumber(assertion, info, value);
        if (Values.compare(value, expected) < 0) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeLess.shouldBeLess(value, expected));
    }

    public static <A extends AbstractAssert<?>> A isGreaterThanOrEqualTo(A assertion, WritableAssertionInfo info, Value value, Number expected) {
        AssertionsOnValueType.isNumber(assertion, info, value);
        if (Values.compare(value, expected) >= 0) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeGreaterOrEqual.shouldBeGreaterOrEqual(value, expected));
    }

    public static <A extends AbstractAssert<?>> A isLessThanOrEqualTo(A assertion, WritableAssertionInfo info, Value value, Number expected) {
        AssertionsOnValueType.isNumber(assertion, info, value);
        if (Values.compare(value, expected) <= 0) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeLessOrEqual.shouldBeLessOrEqual(value, expected));
    }
}

