/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.internal.bytebuddy.implementation.bytecode.constant;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.assertj.db.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.db.internal.bytebuddy.description.method.MethodList;
import org.assertj.db.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.db.internal.bytebuddy.implementation.Implementation;
import org.assertj.db.internal.bytebuddy.implementation.auxiliary.PrivilegedMemberLookupAction;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.Duplication;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.TypeCreation;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.constant.ClassConstant;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.assertj.db.internal.bytebuddy.jar.asm.MethodVisitor;
import org.assertj.db.internal.bytebuddy.matcher.ElementMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodConstant
implements StackManipulation {
    protected final MethodDescription.InDefinedShape methodDescription;

    protected MethodConstant(MethodDescription.InDefinedShape methodDescription) {
        this.methodDescription = methodDescription;
    }

    public static CanCache of(MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription);
        }
        return new ForMethod(methodDescription);
    }

    public static CanCache ofPrivileged(MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription).privileged();
        }
        return new ForMethod(methodDescription).privileged();
    }

    protected static List<StackManipulation> typeConstantsFor(List<TypeDescription> parameterTypes) {
        ArrayList<StackManipulation> typeConstants = new ArrayList<StackManipulation>(parameterTypes.size());
        for (TypeDescription parameterType : parameterTypes) {
            typeConstants.add(ClassConstant.of(parameterType));
        }
        return typeConstants;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return new StackManipulation.Compound(ClassConstant.of(this.methodDescription.getDeclaringType()), this.methodName(), ArrayFactory.forType(TypeDescription.Generic.OfNonGenericType.CLASS).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke(this.accessorMethod())).apply(methodVisitor, implementationContext);
    }

    protected CanCache privileged() {
        return new PrivilegedLookup(this.methodDescription, this.methodName());
    }

    protected abstract StackManipulation methodName();

    protected abstract MethodDescription.InDefinedShape accessorMethod();

    public int hashCode() {
        return this.methodDescription.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodConstant methodConstant = (MethodConstant)other;
        return this.methodDescription.equals(methodConstant.methodDescription);
    }

    protected static class CachedConstructor
    implements StackManipulation {
        private static final TypeDescription CONSTRUCTOR_TYPE = TypeDescription.ForLoadedType.of(Constructor.class);
        private final StackManipulation constructorConstant;

        protected CachedConstructor(StackManipulation constructorConstant) {
            this.constructorConstant = constructorConstant;
        }

        public boolean isValid() {
            return this.constructorConstant.isValid();
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.constructorConstant, CONSTRUCTOR_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public int hashCode() {
            return this.constructorConstant.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedConstructor cachedConstructor = (CachedConstructor)other;
            return this.constructorConstant.equals(cachedConstructor.constructorConstant);
        }
    }

    protected static class CachedMethod
    implements StackManipulation {
        private static final TypeDescription METHOD_TYPE = TypeDescription.ForLoadedType.of(Method.class);
        private final StackManipulation methodConstant;

        protected CachedMethod(StackManipulation methodConstant) {
            this.methodConstant = methodConstant;
        }

        public boolean isValid() {
            return this.methodConstant.isValid();
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.methodConstant, METHOD_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public int hashCode() {
            return this.methodConstant.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedMethod cachedMethod = (CachedMethod)other;
            return this.methodConstant.equals(cachedMethod.methodConstant);
        }
    }

    protected static class PrivilegedLookup
    implements StackManipulation,
    CanCache {
        private static final MethodDescription.InDefinedShape DO_PRIVILEGED;
        private final MethodDescription.InDefinedShape methodDescription;
        private final StackManipulation methodName;

        protected PrivilegedLookup(MethodDescription.InDefinedShape methodDescription, StackManipulation methodName) {
            this.methodDescription = methodDescription;
            this.methodName = methodName;
        }

        public boolean isValid() {
            return this.methodName.isValid();
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            TypeDescription auxiliaryType = implementationContext.register(PrivilegedMemberLookupAction.of(this.methodDescription));
            return new StackManipulation.Compound(TypeCreation.of(auxiliaryType), Duplication.SINGLE, ClassConstant.of(this.methodDescription.getDeclaringType()), this.methodName, ArrayFactory.forType(TypeDescription.Generic.OfNonGenericType.CLASS).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)auxiliaryType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), MethodInvocation.invoke(DO_PRIVILEGED), TypeCasting.to(TypeDescription.ForLoadedType.of(this.methodDescription.isConstructor() ? Constructor.class : Method.class))).apply(methodVisitor, implementationContext);
        }

        public StackManipulation cached() {
            return this.methodDescription.isConstructor() ? new CachedConstructor(this) : new CachedMethod(this);
        }

        public int hashCode() {
            return this.methodDescription.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            PrivilegedLookup privilegedLookup = (PrivilegedLookup)other;
            return this.methodDescription.equals(privilegedLookup.methodDescription);
        }

        static {
            try {
                DO_PRIVILEGED = new MethodDescription.ForLoadedMethod(AccessController.class.getMethod("doPrivileged", PrivilegedExceptionAction.class));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Cannot locate AccessController::doPrivileged", exception);
            }
        }
    }

    protected static class ForConstructor
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_CONSTRUCTOR;
        private static final MethodDescription.InDefinedShape GET_DECLARED_CONSTRUCTOR;

        protected ForConstructor(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        protected StackManipulation methodName() {
            return StackManipulation.Trivial.INSTANCE;
        }

        protected MethodDescription.InDefinedShape accessorMethod() {
            return this.methodDescription.isPublic() ? GET_CONSTRUCTOR : GET_DECLARED_CONSTRUCTOR;
        }

        public StackManipulation cached() {
            return new CachedConstructor(this);
        }

        static {
            try {
                GET_CONSTRUCTOR = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getConstructor", Class[].class));
                GET_DECLARED_CONSTRUCTOR = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredConstructor", Class[].class));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Could not locate Class::getDeclaredConstructor", exception);
            }
        }
    }

    protected static class ForMethod
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_METHOD;
        private static final MethodDescription.InDefinedShape GET_DECLARED_METHOD;

        protected ForMethod(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        protected StackManipulation methodName() {
            return new TextConstant(this.methodDescription.getInternalName());
        }

        protected MethodDescription.InDefinedShape accessorMethod() {
            return this.methodDescription.isPublic() ? GET_METHOD : GET_DECLARED_METHOD;
        }

        public StackManipulation cached() {
            return new CachedMethod(this);
        }

        static {
            try {
                GET_METHOD = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getMethod", String.class, Class[].class));
                GET_DECLARED_METHOD = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredMethod", String.class, Class[].class));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Could not locate method lookup", exception);
            }
        }
    }

    public static interface CanCache
    extends StackManipulation {
        public StackManipulation cached();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CanCacheIllegal implements CanCache
    {
        INSTANCE;


        @Override
        public StackManipulation cached() {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackManipulation.Illegal.INSTANCE.apply(methodVisitor, implementationContext);
        }
    }
}

