/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.ThrowableCause;

public class GenericDeadLetter<M extends Message<?>>
implements DeadLetter<M> {
    public static Clock clock = Clock.systemUTC();
    private final Object sequenceIdentifier;
    private final M message;
    private final Cause cause;
    private final Instant enqueuedAt;
    private final Instant lastTouched;
    private final MetaData diagnostics;

    public GenericDeadLetter(Object sequenceIdentifier, M message) {
        this(sequenceIdentifier, message, null);
    }

    public GenericDeadLetter(Object sequenceIdentifier, M message, Throwable cause) {
        this(sequenceIdentifier, message, cause != null ? new ThrowableCause(cause) : null, () -> clock.instant());
    }

    private GenericDeadLetter(Object sequenceIdentifier, M message, Cause cause, Supplier<Instant> timeSupplier) {
        this(sequenceIdentifier, message, cause, timeSupplier.get(), timeSupplier.get(), MetaData.emptyInstance());
    }

    private GenericDeadLetter(GenericDeadLetter<M> delegate, Instant touched) {
        this(delegate.sequenceIdentifier, delegate.message(), delegate.cause().orElse(null), delegate.enqueuedAt(), touched, delegate.diagnostics);
    }

    private GenericDeadLetter(GenericDeadLetter<M> delegate, MetaData diagnostics) {
        this(delegate.sequenceIdentifier, delegate.message(), delegate.cause().orElse(null), delegate.enqueuedAt(), clock.instant(), diagnostics);
    }

    private GenericDeadLetter(GenericDeadLetter<M> delegate, Throwable requeueCause) {
        this(delegate.sequenceIdentifier, delegate.message(), requeueCause != null ? ThrowableCause.asCause(requeueCause) : delegate.cause, delegate.enqueuedAt(), clock.instant(), delegate.diagnostics());
    }

    public GenericDeadLetter(Object sequenceIdentifier, M message, Cause cause, Instant enqueuedAt, Instant lastTouched, MetaData diagnostics) {
        this.sequenceIdentifier = sequenceIdentifier;
        this.message = message;
        this.cause = cause;
        this.enqueuedAt = enqueuedAt;
        this.lastTouched = lastTouched;
        this.diagnostics = diagnostics;
    }

    @Override
    public M message() {
        return this.message;
    }

    @Override
    public Optional<Cause> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public Instant enqueuedAt() {
        return this.enqueuedAt;
    }

    @Override
    public Instant lastTouched() {
        return this.lastTouched;
    }

    @Override
    public MetaData diagnostics() {
        return this.diagnostics;
    }

    @Override
    public DeadLetter<M> markTouched() {
        return new GenericDeadLetter<M>(this, clock.instant());
    }

    @Override
    public DeadLetter<M> withCause(@Nonnull Throwable requeueCause) {
        return new GenericDeadLetter<M>(this, requeueCause);
    }

    @Override
    public DeadLetter<M> withDiagnostics(MetaData diagnostics) {
        return new GenericDeadLetter<M>(this, diagnostics);
    }

    public Object getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericDeadLetter that = (GenericDeadLetter)o;
        return Objects.equals(this.sequenceIdentifier, that.sequenceIdentifier) && Objects.equals(this.message, that.message) && Objects.equals(this.cause, that.cause) && Objects.equals(this.enqueuedAt, that.enqueuedAt) && Objects.equals(this.lastTouched, that.lastTouched) && Objects.equals(this.diagnostics, that.diagnostics);
    }

    public int hashCode() {
        return Objects.hash(this.sequenceIdentifier, this.message, this.cause, this.enqueuedAt, this.lastTouched, this.diagnostics);
    }

    public String toString() {
        return "GenericDeadLetter{sequenceIdentifier=" + this.sequenceIdentifier + ", message=" + this.message + ", cause=" + this.cause + ", enqueuedAt=" + this.enqueuedAt + ", lastTouched=" + this.lastTouched + ", diagnostics=" + this.diagnostics + '}';
    }
}

