/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.cache.redis.RedisCache;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.ioc.Discoverer;
import org.b3log.latke.repository.jdbc.util.Connections;

public final class Latkes {
    private static final Logger LOGGER = LogManager.getLogger(Latkes.class);
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    public static final String VERSION = "3.4.13";
    public static long startupTimeMillis = System.currentTimeMillis();
    private static Properties localProps;
    private static Properties latkeProps;
    private static RuntimeMode runtimeMode;
    private static String staticResourceVersion;
    private static String contextPath;
    private static String staticPath;
    private static String scanPath;
    private static boolean inited;
    private static boolean enabledSession;
    private static final ThreadLocal<String> SCHEME;
    private static final ThreadLocal<String> HOST;
    private static final ThreadLocal<String> PORT;
    private static boolean inJar;
    private static String PUBLIC_IP;

    public static void setScheme(String scheme) {
        SCHEME.set(scheme);
    }

    public static void setHost(String host) {
        HOST.set(host);
    }

    public static void setPort(String port) {
        PORT.set(port);
    }

    public static void clearSchemeHostPort() {
        SCHEME.remove();
        HOST.remove();
        PORT.remove();
    }

    public static void setEnabledSession(boolean enabled) {
        enabledSession = enabled;
    }

    public static boolean isEnabledSession() {
        return enabledSession;
    }

    public static boolean isDocker() {
        return 1L == Latkes.currentPID();
    }

    public static long currentPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public static boolean isInJar() {
        return inJar;
    }

    public static void setLocalProps(Properties props) {
        localProps = props;
    }

    public static void setLocalProperty(String key, String value) {
        if (null == key) {
            LOGGER.log(Level.WARN, "local.props can not set null key");
            return;
        }
        if (null == value) {
            LOGGER.log(Level.WARN, "local.props can not set null value");
            return;
        }
        localProps.setProperty(key, value);
    }

    public static void setLatkeProps(Properties props) {
        latkeProps = props;
    }

    public static void setLatkeProperty(String key, String value) {
        if (null == key) {
            LOGGER.log(Level.WARN, "latke.props can not set null key");
            return;
        }
        if (null == value) {
            LOGGER.log(Level.WARN, "latke.props can not set null value");
            return;
        }
        latkeProps.setProperty(key, value);
    }

    private static void loadLocalProps() {
        if (null == localProps) {
            localProps = new Properties();
        }
        try {
            InputStream resourceAsStream;
            String localPropsEnv = System.getenv("LATKE_LOCAL_PROPS");
            if (StringUtils.isNotBlank((String)localPropsEnv)) {
                LOGGER.debug("Loading local.properties from env var [$LATKE_LOCAL_PROPS=" + localPropsEnv + "]");
                resourceAsStream = new FileInputStream(localPropsEnv);
            } else {
                LOGGER.debug("Loading local.properties from classpath [/local.properties]");
                resourceAsStream = Latkes.class.getResourceAsStream("/local.properties");
            }
            if (null != resourceAsStream) {
                localProps.load(resourceAsStream);
                LOGGER.debug("Loaded local.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.DEBUG, "Loads local.properties failed, ignored");
        }
    }

    private static void loadLatkeProps() {
        if (null == latkeProps) {
            latkeProps = new Properties();
        }
        try {
            InputStream resourceAsStream;
            String latkePropsEnv = System.getenv("LATKE_PROPS");
            if (StringUtils.isNotBlank((String)latkePropsEnv)) {
                LOGGER.debug("Loading latke.properties from env var [$LATKE_PROPS=" + latkePropsEnv + "]");
                resourceAsStream = new FileInputStream(latkePropsEnv);
            } else {
                LOGGER.debug("Loading latke.properties from classpath [/latke.properties]");
                resourceAsStream = Latkes.class.getResourceAsStream("/latke.properties");
            }
            if (null != resourceAsStream) {
                latkeProps.load(resourceAsStream);
                LOGGER.debug("Loaded latke.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Loads latke.properties failed", (Throwable)e);
            throw new RuntimeException("Loads latke.properties failed");
        }
    }

    public static String getStaticResourceVersion() {
        if (null == staticResourceVersion && null == (staticResourceVersion = Latkes.getLatkeProperty("staticResourceVersion"))) {
            staticResourceVersion = String.valueOf(startupTimeMillis);
        }
        return staticResourceVersion;
    }

    public static void setStaticResourceVersion(String staticResourceVersion) {
        Latkes.staticResourceVersion = staticResourceVersion;
    }

    public static String getServerScheme() {
        String scheme = SCHEME.get();
        if (null != scheme) {
            return scheme;
        }
        String ret = Latkes.getLatkeProperty("serverScheme");
        if (null == ret) {
            ret = "http";
        }
        return ret;
    }

    public static void setServerScheme(String serverScheme) {
        Latkes.setLatkeProperty("serverScheme", serverScheme);
    }

    public static String getServerHost() {
        String host = HOST.get();
        if (null != host) {
            return host;
        }
        String ret = Latkes.getLatkeProperty("serverHost");
        if (null == ret) {
            ret = "localhost";
        }
        return ret;
    }

    public static void setServerHost(String serverHost) {
        Latkes.setLatkeProperty("serverHost", serverHost);
    }

    public static String getServerPort() {
        String port = PORT.get();
        if (null != port) {
            return port;
        }
        String ret = Latkes.getLatkeProperty("serverPort");
        if (null == ret) {
            ret = "8080";
        }
        return ret;
    }

    public static void setServerPort(String serverPort) {
        Latkes.setLatkeProperty("serverPort", serverPort);
    }

    public static String getPublicIP() {
        if (StringUtils.isBlank((String)PUBLIC_IP)) {
            Latkes.initPublicIP();
        }
        return PUBLIC_IP;
    }

    public static synchronized void initPublicIP() {
        if (StringUtils.isNotBlank((String)PUBLIC_IP)) {
            return;
        }
        try {
            URL url = new URL("http://checkip.amazonaws.com");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(3000);
            urlConnection.setReadTimeout(3000);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                PUBLIC_IP = in.readLine();
            }
            urlConnection.disconnect();
            return;
        }
        catch (Exception e) {
            try {
                PUBLIC_IP = InetAddress.getLocalHost().getHostAddress();
                return;
            }
            catch (Exception exception) {
                PUBLIC_IP = "127.0.0.1";
                return;
            }
        }
    }

    public static String getServer() {
        StringBuilder serverBuilder = new StringBuilder(Latkes.getServerScheme()).append("://").append(Latkes.getServerHost());
        String port = Latkes.getServerPort();
        if (StringUtils.isNotBlank((String)port) && !"80".equals(port) && !"443".equals(port)) {
            serverBuilder.append(':').append(port);
        }
        return serverBuilder.toString();
    }

    public static String getServePath() {
        return Latkes.getServer() + Latkes.getContextPath();
    }

    public static String getStaticServerScheme() {
        String ret = Latkes.getLatkeProperty("staticServerScheme");
        if (null == ret) {
            return Latkes.getServerScheme();
        }
        return ret;
    }

    public static void setStaticServerScheme(String staticServerScheme) {
        Latkes.setLatkeProperty("staticServerScheme", staticServerScheme);
    }

    public static String getStaticServerHost() {
        String ret = Latkes.getLatkeProperty("staticServerHost");
        if (null == ret) {
            return Latkes.getServerHost();
        }
        return ret;
    }

    public static void setStaticServerHost(String staticServerHost) {
        Latkes.setLatkeProperty("staticServerHost", staticServerHost);
    }

    public static String getStaticServerPort() {
        String ret = Latkes.getLatkeProperty("staticServerPort");
        if (null == ret) {
            return Latkes.getServerPort();
        }
        return ret;
    }

    public static void setStaticServerPort(String staticServerPort) {
        Latkes.setLatkeProperty("staticServerPort", staticServerPort);
    }

    public static String getStaticServer() {
        StringBuilder staticServerBuilder = new StringBuilder(Latkes.getStaticServerScheme()).append("://").append(Latkes.getStaticServerHost());
        String port = Latkes.getStaticServerPort();
        if (StringUtils.isNotBlank((String)port) && !"80".equals(port) && !"443".equals(port)) {
            staticServerBuilder.append(':').append(port);
        }
        return staticServerBuilder.toString();
    }

    public static String getStaticServePath() {
        return Latkes.getStaticServer() + Latkes.getStaticPath();
    }

    public static String getContextPath() {
        if (null != contextPath) {
            return contextPath;
        }
        String contextPathConf = Latkes.getLatkeProperty("contextPath");
        if (null != contextPathConf) {
            contextPath = contextPathConf;
            return contextPath;
        }
        contextPath = "";
        return contextPath;
    }

    public static void setContextPath(String contextPath) {
        Latkes.contextPath = contextPath;
    }

    public static String getStaticPath() {
        if (null == staticPath && null == (staticPath = Latkes.getLatkeProperty("staticPath"))) {
            staticPath = Latkes.getContextPath();
        }
        return staticPath;
    }

    public static void setStaticPath(String staticPath) {
        Latkes.staticPath = staticPath;
    }

    public static String getScanPath() {
        if (null == scanPath && StringUtils.isBlank((String)(scanPath = Latkes.getLatkeProperty("scanPath")))) {
            scanPath = "org.b3log";
            LOGGER.log(Level.INFO, "IoC scan path is empty, uses \"org.b3log\" as default scan path");
        }
        return scanPath;
    }

    public static void setScanPath(String scanPath) {
        Latkes.scanPath = scanPath;
    }

    public static synchronized void init() {
        if (inited) {
            return;
        }
        inited = true;
        LOGGER.log(Level.TRACE, "Initializing Latke");
        Latkes.loadLatkeProps();
        Latkes.loadLocalProps();
        if (null == runtimeMode) {
            String runtimeModeValue = Latkes.getLatkeProperty("runtimeMode");
            if (null != runtimeModeValue) {
                runtimeMode = RuntimeMode.valueOf(runtimeModeValue);
            } else {
                LOGGER.log(Level.TRACE, "Can't parse runtime mode in latke.properties, default to [PRODUCTION]");
                runtimeMode = RuntimeMode.PRODUCTION;
            }
        }
        if (RuntimeMode.DEVELOPMENT == Latkes.getRuntimeMode()) {
            LOGGER.warn("!!!!Runtime mode is [" + (Object)((Object)RuntimeMode.DEVELOPMENT) + "], please make sure configured it with [" + (Object)((Object)RuntimeMode.PRODUCTION) + "] in latke.properties if deployed on production environment!!!!");
        } else {
            LOGGER.log(Level.DEBUG, "Runtime mode is [{}]", (Object)Latkes.getRuntimeMode());
        }
        RuntimeDatabase runtimeDatabase = Latkes.getRuntimeDatabase();
        LOGGER.log(Level.DEBUG, "Runtime database is [{}]", (Object)runtimeDatabase);
        RuntimeCache runtimeCache = Latkes.getRuntimeCache();
        LOGGER.log(Level.INFO, "Runtime cache is [{}]", (Object)runtimeCache);
        Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
        Collection<Class<?>> beanClasses = Discoverer.discover(Latkes.getScanPath());
        BeanManager.start(beanClasses);
        LOGGER.log(Level.INFO, "Initialized Latke");
    }

    public static RuntimeMode getRuntimeMode() {
        if (null == runtimeMode) {
            throw new RuntimeException("Runtime mode has not been initialized!");
        }
        return runtimeMode;
    }

    public static void setRuntimeMode(RuntimeMode runtimeMode) {
        Latkes.runtimeMode = runtimeMode;
    }

    public static RuntimeCache getRuntimeCache() {
        String runtimeCache = Latkes.getLocalProperty("runtimeCache");
        if (null == runtimeCache) {
            LOGGER.debug("Not found [runtimeCache] in local.properties, uses [LOCAL_LRU] as default");
            return RuntimeCache.LOCAL_LRU;
        }
        return RuntimeCache.valueOf(runtimeCache);
    }

    public static RuntimeDatabase getRuntimeDatabase() {
        String runtimeDatabase = Latkes.getLocalProperty("runtimeDatabase");
        if (null == runtimeDatabase) {
            throw new RuntimeException("Please configures runtime database in local.properties!");
        }
        RuntimeDatabase ret = RuntimeDatabase.valueOf(runtimeDatabase);
        if (null == ret) {
            throw new RuntimeException("Please configures a valid runtime database in local.properties!");
        }
        return ret;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void setLocale(Locale locale) {
        Locale.setDefault(locale);
    }

    public static String getLocalProperty(String key) {
        String ret = localProps.getProperty(key);
        if (StringUtils.isBlank((String)ret)) {
            return ret;
        }
        ret = Latkes.replaceEnvVars(ret);
        return ret;
    }

    public static String getLatkeProperty(String key) {
        String ret = latkeProps.getProperty(key);
        if (StringUtils.isBlank((String)ret)) {
            return ret;
        }
        ret = Latkes.replaceEnvVars(ret);
        return ret;
    }

    public static void shutdown() {
        try {
            EXECUTOR_SERVICE.shutdown();
            if (RuntimeCache.REDIS == Latkes.getRuntimeCache()) {
                RedisCache.shutdown();
            }
            Connections.shutdownConnectionPool();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Shutdowns Latke failed", (Throwable)e);
        }
        BeanManager.close();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                LOGGER.log(Level.TRACE, "Unregistered JDBC driver [" + driver + "]");
            }
            catch (SQLException e) {
                LOGGER.log(Level.ERROR, "Unregister JDBC driver [" + driver + "] failed", (Throwable)e);
            }
        }
    }

    public static String getSkinName(String skinDirName) {
        try {
            Properties ret = new Properties();
            File file = Latkes.getFile("/skins/" + skinDirName + "/skin.properties");
            ret.load(new FileInputStream(file));
            return ret.getProperty("name");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Read skin [" + skinDirName + "]'s configuration failed: " + e.getMessage());
            return null;
        }
    }

    public static File getFile(String path) {
        try {
            URL resource = Latkes.class.getResource(path);
            if (null == resource) {
                return null;
            }
            File ret = FileUtils.toFile((URL)resource);
            if (null == ret) {
                File tempdir = FileUtils.getTempDirectory();
                ret = new File(tempdir.getPath() + path);
                FileUtils.copyURLToFile((URL)resource, (File)ret);
                ret.deleteOnExit();
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Reads file [path=" + path + "] failed", (Throwable)e);
            return null;
        }
    }

    public static List<String> listFiles(String path) {
        ArrayList<String> ret = new ArrayList<String>();
        try (InputStream in = Latkes.class.getResourceAsStream(path);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String resource;
            while ((resource = br.readLine()) != null) {
                ret.add(path + "/" + resource);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Read file names [path=" + path + "] failed", (Throwable)e);
        }
        return ret;
    }

    private static String replaceEnvVars(String val) {
        String ret = val;
        String[] envVars = StringUtils.substringsBetween((String)ret, (String)"${", (String)"}");
        if (null != envVars) {
            for (String envKey : envVars) {
                String envVal = System.getenv(envKey);
                if (StringUtils.isBlank((String)envVal)) {
                    envVal = "";
                }
                ret = StringUtils.replace((String)ret, (String)("${" + envKey + "}"), (String)envVal);
            }
        }
        return ret;
    }

    private Latkes() {
    }

    static {
        enabledSession = true;
        SCHEME = new ThreadLocal();
        HOST = new ThreadLocal();
        PORT = new ThreadLocal();
        try {
            URL resource = Latkes.class.getResource("/latke.properties");
            inJar = null == resource || "jar".equals(resource.toURI().getScheme());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Checks filesystem failed, exit", (Throwable)e);
            System.exit(-1);
        }
    }

    public static enum RuntimeMode {
        DEVELOPMENT,
        PRODUCTION;

    }

    public static enum RuntimeCache {
        NONE,
        LOCAL_LRU,
        REDIS;

    }

    public static enum RuntimeDatabase {
        NONE,
        MYSQL,
        H2;

    }
}

