/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.cache.Cache;

public final class CacheFactory {
    private static final Logger LOGGER = LogManager.getLogger(CacheFactory.class);
    private static final Map<String, Cache> CACHES = Collections.synchronizedMap(new HashMap());
    protected static final int EXPIRE_SECONDS = 21600;

    private CacheFactory() {
    }

    public static Cache getCache(String cacheName, int expireSeconds) {
        LOGGER.log(Level.INFO, "Constructing cache [name={}]....", (Object)cacheName);
        Cache ret = CACHES.get(cacheName);
        try {
            if (null == ret) {
                Class<?> cacheClass;
                switch (Latkes.getRuntimeCache()) {
                    case LOCAL_LRU: {
                        cacheClass = Class.forName("org.b3log.latke.cache.guava.GuavaCache");
                        break;
                    }
                    case REDIS: {
                        cacheClass = Class.forName("org.b3log.latke.cache.redis.RedisCache");
                        break;
                    }
                    case NONE: {
                        cacheClass = Class.forName("org.b3log.latke.cache.NoneCache");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Latke runs in the hell.... Please set the environment correctly");
                    }
                }
                Constructor<?> constructor = cacheClass.getConstructor(Integer.TYPE);
                ret = (Cache)constructor.newInstance(expireSeconds);
                ret.setName(cacheName);
                CACHES.put(cacheName, ret);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get cache: " + e.getMessage(), e);
        }
        LOGGER.log(Level.INFO, "Constructed cache [name={}, runtime={}]", (Object)cacheName, (Object)Latkes.getRuntimeCache());
        return ret;
    }

    public static Cache getCache(String cacheName) {
        return CacheFactory.getCache(cacheName, 21600);
    }

    public static synchronized void clear() {
        for (Map.Entry<String, Cache> entry : CACHES.entrySet()) {
            Cache cache = entry.getValue();
            cache.clear();
            LOGGER.log(Level.TRACE, "Cleared cache [name={}]", (Object)entry.getKey());
        }
    }
}

