/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.cache.AbstractCache;
import org.b3log.latke.cache.redis.Connections;
import org.json.JSONObject;
import redis.clients.jedis.Jedis;

public final class RedisCache
extends AbstractCache {
    private static final Logger LOGGER = LogManager.getLogger(RedisCache.class);
    private static final String KEY_PREFIX;

    public RedisCache(int expireSeconds) {
        super(expireSeconds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(String key) {
        try (Jedis jedis = Connections.getJedis();){
            boolean bl = jedis.exists(this.getKeyPrefix() + key);
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Contains key [" + key + "] failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public void put(String key, JSONObject value) {
        this.put(key, value, this.expireSeconds);
    }

    @Override
    public void put(String key, JSONObject value, int expireSeconds) {
        try (Jedis jedis = Connections.getJedis();){
            jedis.setex(this.getKeyPrefix() + key, expireSeconds, value.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Put data to cache with key [" + key + "] failed", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject get(String key) {
        try (Jedis jedis = Connections.getJedis();){
            String s = jedis.get(this.getKeyPrefix() + key);
            if (null == s) {
                JSONObject jSONObject2 = null;
                return jSONObject2;
            }
            JSONObject jSONObject = new JSONObject(s);
            return jSONObject;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get data from cache with key [" + key + "] failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public void remove(String key) {
        try (Jedis jedis = Connections.getJedis();){
            jedis.del(this.getKeyPrefix() + key);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Remove data to cache with key [" + key + "] failed", (Throwable)e);
        }
    }

    @Override
    public void remove(Collection<String> keys) {
        ArrayList<String> cacheKeys = new ArrayList<String>(keys.size());
        String keyPrefix = this.getKeyPrefix();
        for (String key : keys) {
            cacheKeys.add(keyPrefix + key);
        }
        try (Jedis jedis = Connections.getJedis();){
            jedis.del(cacheKeys.toArray(new String[0]));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Remove data to cache with keys [" + keys + "] failed", (Throwable)e);
        }
    }

    @Override
    public void clear() {
        try (Jedis jedis = Connections.getJedis();){
            Set keys = jedis.keys(this.getKeyPrefix() + "*");
            if (keys.isEmpty()) {
                return;
            }
            jedis.del(keys.toArray(new String[0]));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Clear cache failed", (Throwable)e);
        }
    }

    public static void shutdown() {
        try {
            Connections.shutdown();
            LOGGER.debug("Closed Redis connection pool");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Shutdown redis connection pool failed", (Throwable)e);
        }
    }

    private String getKeyPrefix() {
        return KEY_PREFIX + this.getName();
    }

    static {
        String keyPrefix = Latkes.getLocalProperty("redis.keyPrefix");
        if (StringUtils.isBlank((String)keyPrefix)) {
            keyPrefix = "latke";
        }
        KEY_PREFIX = keyPrefix;
    }
}

