/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.event;

import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.SynchronizedEventQueue;
import org.b3log.latke.ioc.Singleton;

@Singleton
public class EventManager {
    private final SynchronizedEventQueue synchronizedEventQueue = new SynchronizedEventQueue(this);

    public void fireEventSynchronously(Event<?> event) {
        this.synchronizedEventQueue.fireEvent(event);
    }

    public <T> Future<T> fireEventAsynchronously(Event<?> event) {
        FutureTask<Object> futureTask = new FutureTask<Object>(() -> {
            this.synchronizedEventQueue.fireEvent(event);
            return null;
        });
        Latkes.EXECUTOR_SERVICE.execute(futureTask);
        return futureTask;
    }

    public void registerListener(AbstractEventListener<?> eventListener) {
        this.synchronizedEventQueue.addListener(eventListener);
    }

    public void unregisterListener(AbstractEventListener<?> eventListener) {
        this.synchronizedEventQueue.deleteListener(eventListener);
    }
}

