/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.http.ServerHandler;
import org.b3log.latke.http.WebSocketHandler;

public abstract class BaseServer {
    private static final Logger LOGGER = LogManager.getLogger(BaseServer.class);
    private static final EventLoopGroup BOSS_GROUP;
    private static final EventLoopGroup WORKER_GROUP;
    private static final Class<? extends ServerSocketChannel> SOCKET_CHANNEL_CLASS;
    private static final Class<? extends ServerDomainSocketChannel> DOMAIN_SOCKET_CHANNEL_CLASS;

    public void start(int listenPort) {
        LOGGER.log(Level.TRACE, "Using [" + SOCKET_CHANNEL_CLASS.getSimpleName() + "] as underlying implementation of server socket channel");
        this.startServer(new InetSocketAddress(listenPort), SOCKET_CHANNEL_CLASS);
    }

    public void start(String socketPath) {
        if (DOMAIN_SOCKET_CHANNEL_CLASS == null) {
            LOGGER.error("Unix domain socket is not supported on this platform");
            System.exit(-1);
        }
        LOGGER.log(Level.TRACE, "Using [" + DOMAIN_SOCKET_CHANNEL_CLASS.getSimpleName() + "] as underlying implementation of server socket channel");
        this.startServer((SocketAddress)new DomainSocketAddress(socketPath), DOMAIN_SOCKET_CHANNEL_CLASS);
    }

    public void shutdown() {
        this.shutdownServer();
    }

    private void startServer(SocketAddress socketAddress, Class<? extends ServerChannel> channelClass) {
        try {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
            ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(BOSS_GROUP, WORKER_GROUP).channel(channelClass)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new HttpServerInitializer()).bind(socketAddress).sync().channel().closeFuture().sync();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Start server failed, exit process", (Throwable)e);
            System.exit(-1);
        }
    }

    private void shutdownServer() {
        try {
            LOGGER.log(Level.INFO, "HTTP server is shutting down");
            BOSS_GROUP.shutdownGracefully(1L, 7L, TimeUnit.SECONDS).await();
            WORKER_GROUP.shutdownGracefully(1L, 7L, TimeUnit.SECONDS).await();
            LOGGER.log(Level.INFO, "HTTP server has shut down");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Shutdown server failed", (Throwable)e);
        }
    }

    static {
        if (Epoll.isAvailable()) {
            BOSS_GROUP = new EpollEventLoopGroup(1);
            WORKER_GROUP = new EpollEventLoopGroup();
            SOCKET_CHANNEL_CLASS = EpollServerSocketChannel.class;
            DOMAIN_SOCKET_CHANNEL_CLASS = EpollServerDomainSocketChannel.class;
        } else if (KQueue.isAvailable()) {
            BOSS_GROUP = new KQueueEventLoopGroup(1);
            WORKER_GROUP = new KQueueEventLoopGroup();
            SOCKET_CHANNEL_CLASS = KQueueServerSocketChannel.class;
            DOMAIN_SOCKET_CHANNEL_CLASS = KQueueServerDomainSocketChannel.class;
        } else {
            BOSS_GROUP = new NioEventLoopGroup(1);
            WORKER_GROUP = new NioEventLoopGroup();
            SOCKET_CHANNEL_CLASS = NioServerSocketChannel.class;
            DOMAIN_SOCKET_CHANNEL_CLASS = null;
        }
    }

    private static final class HttpServerInitializer
    extends ChannelInitializer<Channel> {
        private HttpServerInitializer() {
        }

        public void initChannel(Channel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x4000000)});
            pipeline.addLast(new ChannelHandler[]{new WebSocketHandler()});
            pipeline.addLast(new ChannelHandler[]{new ServerHandler()});
        }
    }
}

