/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.Response;
import org.b3log.latke.http.function.Handler;
import org.b3log.latke.http.renderer.AbstractResponseRenderer;
import org.b3log.latke.http.renderer.Http500Renderer;
import org.b3log.latke.http.renderer.JsonRenderer;
import org.b3log.latke.util.Requests;
import org.json.JSONObject;

public final class RequestContext {
    private static final Logger LOGGER = LogManager.getLogger(RequestContext.class);
    public static final String MATCH_RESULT = "MATCH_RESULT";
    public static final String ERROR_CODE = "ERROR_CODE";
    private Request request;
    private Response response;
    private AbstractResponseRenderer renderer;
    private Map<String, String> pathVars = new HashMap<String, String>();
    private int handleIndex = -1;
    private final List<Handler> handlers = new ArrayList<Handler>();

    public RequestContext(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public AbstractResponseRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(AbstractResponseRenderer renderer) {
        this.renderer = renderer;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Map<String, Object> getDataModel() {
        AbstractResponseRenderer renderer = this.getRenderer();
        if (null == renderer) {
            return null;
        }
        return renderer.getRenderDataModel();
    }

    public String remoteAddr() {
        return Requests.getRemoteAddr(this.request);
    }

    public String header(String name) {
        return this.request.getHeader(name);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String method() {
        return this.request.getMethod();
    }

    public String requestURI() {
        return this.request.getRequestURI();
    }

    public Object attr(String name) {
        return this.request.getAttribute(name);
    }

    public void attr(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public String param(String name) {
        try {
            return this.request.getParameter(name);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can't parse request parameter [uri=" + this.request.getRequestURI() + ", method=" + this.request.getMethod() + ", parameterName=" + name + "]: " + e.getMessage());
            return null;
        }
    }

    public byte[] requestBytes() {
        return this.request.getBytes();
    }

    public String requestQueryStr() {
        return this.request.getQueryString();
    }

    public String pathVar(String name) {
        return this.pathVars.get(name);
    }

    public Map<String, String> pathVars() {
        return this.pathVars;
    }

    public void pathVars(Map<String, String> pathVars) {
        this.pathVars = pathVars;
    }

    public void pathVar(String name, String value) {
        this.pathVars.put(name, value);
    }

    public void sendError(int sc) {
        this.response.sendError(sc);
    }

    public void sendError(int sc, Map<String, Object> dataModel) {
        this.response.sendError(sc, dataModel);
    }

    public void sendStatus(int sc) {
        this.response.setStatus(sc);
        this.response.send();
    }

    public void sendRedirect(String location) {
        try {
            this.response.sendRedirect(new URI(location).toASCIIString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sends redirect [" + location + "] failed: " + e.getMessage());
        }
    }

    public void sendBytes(byte[] bytes) {
        this.response.sendBytes(bytes);
    }

    public void sendString(String string) {
        this.response.sendString(string);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public JSONObject requestJSON() {
        return this.request.getJSON();
    }

    public RequestContext renderJSONPretty(JSONObject json) {
        JsonRenderer jsonRenderer = new JsonRenderer();
        jsonRenderer.setJSONObject(json);
        jsonRenderer.setPretty(true);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderJSON(JSONObject json) {
        JsonRenderer jsonRenderer = new JsonRenderer();
        jsonRenderer.setJSONObject(json);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderJSON(int code) {
        JsonRenderer jsonRenderer = new JsonRenderer();
        JSONObject ret = new JSONObject().put("code", code);
        jsonRenderer.setJSONObject(ret);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderCodeDataMsg(int code, JSONObject data, String msg) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("code", code).put("data", data).put("msg", msg);
        }
        return this;
    }

    public RequestContext renderCodeData(int code, JSONObject data) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("code", code).put("data", data);
        }
        return this;
    }

    public RequestContext renderCodeMsg(int code, String msg) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("code", code).put("msg", msg);
        }
        return this;
    }

    public RequestContext renderCode(int code) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("code", code);
        }
        return this;
    }

    public RequestContext renderMsg(String msg) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("msg", msg);
        }
        return this;
    }

    public RequestContext renderData(Object data) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("data", data);
        }
        return this;
    }

    public RequestContext renderPretty() {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            r.setPretty(true);
        }
        return this;
    }

    public RequestContext renderJSONValue(String name, Object obj) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put(name, obj);
        }
        return this;
    }

    public void handle() {
        try {
            ++this.handleIndex;
            while (this.handleIndex < this.handlers.size()) {
                this.handlers.get(this.handleIndex).handle(this);
                ++this.handleIndex;
            }
        }
        catch (Exception e) {
            String requestLog = Requests.getLog(this.request);
            LOGGER.log(Level.ERROR, "Handler process failed: " + requestLog, (Throwable)e);
            this.setRenderer(new Http500Renderer(e));
        }
    }

    public void abort() {
        this.handleIndex = 64;
    }

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public void addHandlers(List<Handler> handlers) {
        this.handlers.addAll(handlers);
    }

    public void insertHandlerAfter(Handler handler) {
        this.handlers.add(this.handleIndex + 1, handler);
    }
}

