/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.cache.Cache;
import org.b3log.latke.cache.CacheFactory;
import org.b3log.latke.http.Session;
import org.json.JSONObject;

public final class Sessions {
    private static final Logger LOGGER = LogManager.getLogger(Sessions.class);
    public static final Cache CACHE = CacheFactory.getCache("LATKE_SESSIONS");

    public static Session add() {
        if (!Latkes.isEnabledSession()) {
            LOGGER.log(Level.WARN, "Session management is disabled");
            return null;
        }
        String sessionId = RandomStringUtils.randomAlphanumeric((int)16);
        Session ret = new Session(sessionId);
        CACHE.put(sessionId, new JSONObject().put("id", sessionId));
        return ret;
    }

    public static boolean contains(String sessionId) {
        return CACHE.contains(sessionId);
    }

    public static Session get(String sessionId) {
        JSONObject session = CACHE.get(sessionId);
        if (null == session) {
            return null;
        }
        return new Session(session.optString("id"));
    }

    private Sessions() {
    }
}

