/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http.renderer;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.Tika;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.http.Response;
import org.b3log.latke.http.renderer.AbstractResponseRenderer;
import org.b3log.latke.util.URLs;

public class StaticFileRenderer
extends AbstractResponseRenderer {
    private static final Logger LOGGER = LogManager.getLogger(StaticFileRenderer.class);
    private static final Tika TIKA = new Tika();

    @Override
    public void render(RequestContext context) {
        Response response = context.getResponse();
        try {
            byte[] bytes;
            String uri = context.requestURI();
            uri = URLs.decode(uri);
            if (StringUtils.contains((String)uri, (String)Latkes.getStaticPath())) {
                uri = StringUtils.substringAfter((String)uri, (String)Latkes.getStaticPath());
            }
            if (!Latkes.isInJar()) {
                File file;
                String path = Latkes.class.getResource("/latke.properties").getPath();
                path = StringUtils.substringBeforeLast((String)path, (String)"latke.properties");
                if (StringUtils.contains((String)(path = URLs.decode(path)), (String)"/target/classes/") || StringUtils.contains((String)path, (String)"/target/test-classes/")) {
                    path = StringUtils.replace((String)path, (String)"/target/classes/", (String)"/src/main/resources/");
                    path = StringUtils.replace((String)path, (String)"/target/test-classes/", (String)"/src/main/resources/");
                }
                if (!(file = new File(path = path + uri)).exists()) {
                    response.sendError0(404);
                    return;
                }
                bytes = FileUtils.readFileToByteArray((File)file);
            } else {
                try (InputStream inputStream = StaticFileRenderer.class.getResourceAsStream(uri);){
                    bytes = IOUtils.toByteArray((InputStream)inputStream);
                }
            }
            String contentType = TIKA.detect(uri);
            response.setContentType(contentType);
            response.sendBytes(bytes);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Renders static file failed", (Throwable)e);
            response.sendError0(500);
        }
    }
}

