/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.plugin;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.plugin.PluginStatus;
import org.b3log.latke.plugin.PluginType;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractPlugin
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger(AbstractPlugin.class);
    private static final long serialVersionUID = 1L;
    private String id;
    private String rendererId;
    private String name;
    private String author;
    private String version;
    private String dirName;
    private PluginStatus status = PluginStatus.ENABLED;
    private JSONObject setting = new JSONObject();
    private final Set<PluginType> types = new HashSet<PluginType>();
    private final Map<String, Properties> langs = new HashMap<String, Properties>();
    private transient Configuration configuration;

    public void unplug() {
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDir(String dirName) {
        this.dirName = dirName;
        this.initTemplateEngineCfg();
    }

    private void initTemplateEngineCfg() {
        this.configuration = new Configuration(Configuration.VERSION_2_3_29);
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setClassForTemplateLoading(AbstractPlugin.class, "/plugins/" + this.dirName);
        LOGGER.log(Level.DEBUG, "Initialized template configuration");
    }

    public void readLangs() {
        List<String> resourcePaths = Latkes.listFiles("/plugins/" + this.dirName);
        for (String resourcePath : resourcePaths) {
            if (!resourcePath.contains("lang_") || !resourcePath.endsWith(".properties")) continue;
            String langFileName = StringUtils.substringAfter((String)resourcePath, (String)("/plugins/" + this.dirName + "/"));
            String key = langFileName.substring("lang_".length(), langFileName.lastIndexOf("."));
            Properties props = new Properties();
            try {
                File file = Latkes.getFile(resourcePath);
                props.load(new FileInputStream(file));
                this.langs.put(key, props);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Get plugin [name=" + this.name + "]'s language configuration failed", (Throwable)e);
            }
        }
    }

    public String getLang(Locale locale, String key) {
        return this.langs.get(locale.toString()).getProperty(key);
    }

    public abstract void prePlug(RequestContext var1);

    public abstract void postPlug(Map<String, Object> var1, RequestContext var2);

    protected void start() {
    }

    protected void stop() {
    }

    public void plug(Map<String, Object> dataModel) {
        this.plug(dataModel, null);
    }

    public void plug(Map<String, Object> dataModel, RequestContext context) {
        String content = (String)dataModel.get("plugins");
        if (null == content) {
            dataModel.put("plugins", "");
        }
        this.handleLangs(dataModel);
        this.fillDefault(dataModel);
        this.postPlug(dataModel, context);
        content = (String)dataModel.get("plugins");
        StringBuilder contentBuilder = new StringBuilder(content);
        contentBuilder.append(this.getViewContent(dataModel));
        String pluginsContent = contentBuilder.toString();
        dataModel.put("plugins", pluginsContent);
        LOGGER.log(Level.DEBUG, "Plugin[name={}] has been plugged", (Object)this.getName());
    }

    private void handleLangs(Map<String, Object> dataModel) {
        String localKey;
        Properties props;
        Locale locale = Latkes.getLocale();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder keyBuilder = new StringBuilder(language);
        if (StringUtils.isNotBlank((String)country)) {
            keyBuilder.append("_").append(country);
        }
        if (StringUtils.isNotBlank((String)variant)) {
            keyBuilder.append("_").append(variant);
        }
        if (null == (props = this.langs.get(localKey = keyBuilder.toString()))) {
            return;
        }
        Set<Object> keySet = props.keySet();
        for (Object key : keySet) {
            dataModel.put((String)key, props.getProperty((String)key));
        }
    }

    private void fillDefault(Map<String, Object> dataModel) {
        Keys.fillServer(dataModel);
        Keys.fillRuntime(dataModel);
    }

    private String getViewContent(Map<String, Object> dataModel) {
        if (null == this.configuration) {
            this.initTemplateEngineCfg();
        }
        try {
            Template template = this.configuration.getTemplate("plugin.ftl");
            StringWriter sw = new StringWriter();
            template.process(dataModel, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject ret = new JSONObject();
        ret.put(Keys.OBJECT_ID, this.getId());
        ret.put("name", this.getName());
        ret.put("version", this.getVersion());
        ret.put("author", this.getAuthor());
        ret.put("status", this.getStatus().name());
        ret.put("setting", this.getSetting().toString());
        return ret;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStatus(PluginStatus status) {
        this.status = status;
    }

    public PluginStatus getStatus() {
        return this.status;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public JSONObject getSetting() {
        return this.setting;
    }

    public void setSetting(JSONObject setting) {
        this.setting = setting;
    }

    public Set<PluginType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public String getRendererId() {
        return this.rendererId;
    }

    public void setRendererId(String rendererId) {
        this.rendererId = rendererId;
    }

    public void addType(PluginType type) {
        this.types.add(type);
    }

    public boolean equals(Object obj) {
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPlugin other = (AbstractPlugin)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return 2 + (this.id != null ? this.id.hashCode() : 0);
    }

    public void changeStatus() {
        if (PluginStatus.ENABLED.equals((Object)this.status)) {
            this.start();
        } else {
            this.stop();
        }
    }
}

