/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.ioc.Inject;
import org.b3log.latke.ioc.Singleton;
import org.b3log.latke.plugin.AbstractPlugin;
import org.b3log.latke.plugin.NotInteractivePlugin;
import org.b3log.latke.plugin.PluginType;
import org.b3log.latke.util.Stopwatchs;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class PluginManager {
    private static final Logger LOGGER = LogManager.getLogger(PluginManager.class);
    public static final String PLUGIN_LOADED_EVENT = "pluginLoadedEvt";
    private final Map<String, Set<AbstractPlugin>> pluginCache = new HashMap<String, Set<AbstractPlugin>>();
    private final Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();
    @Inject
    private EventManager eventManager;

    public List<AbstractPlugin> getPlugins() {
        if (this.pluginCache.isEmpty()) {
            LOGGER.info("Plugin cache miss, reload");
            this.load();
        }
        return this.pluginCache.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Set<AbstractPlugin> getPlugins(String viewName) {
        if (this.pluginCache.isEmpty()) {
            LOGGER.info("Plugin cache miss, reload");
            this.load();
        }
        return this.pluginCache.getOrDefault(viewName, Collections.emptySet());
    }

    public void load() {
        Stopwatchs.start("Load Plugins");
        this.classLoaders.clear();
        List<String> pluginDirPaths = Latkes.listFiles("/plugins");
        ArrayList<AbstractPlugin> plugins = new ArrayList<AbstractPlugin>();
        for (String pluginDirPath : pluginDirPaths) {
            try {
                LOGGER.log(Level.INFO, "Loading plugin under directory [{}]", (Object)pluginDirPath);
                AbstractPlugin plugin = this.load(pluginDirPath, this.pluginCache);
                if (plugin == null) continue;
                plugins.add(plugin);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Load plugin under directory [" + pluginDirPath + "] failed", (Throwable)e);
            }
        }
        this.eventManager.fireEventSynchronously(new Event(PLUGIN_LOADED_EVENT, plugins));
        Stopwatchs.end();
    }

    private AbstractPlugin load(String pluginDirPath, Map<String, Set<AbstractPlugin>> holder) throws Exception {
        String rendererId;
        Properties props = new Properties();
        String plugin = StringUtils.substringAfter((String)pluginDirPath, (String)"/plugins");
        plugin = plugin.replace("/", "");
        File file = Latkes.getFile("/plugins/" + plugin + "/plugin.properties");
        props.load(new FileInputStream(file));
        URL defaultClassesFileDirURL = PluginManager.class.getResource("/plugins/" + plugin + "classes");
        URLClassLoader classLoader = null != defaultClassesFileDirURL ? new URLClassLoader(new URL[]{defaultClassesFileDirURL}, PluginManager.class.getClassLoader()) : new URLClassLoader(new URL[0], PluginManager.class.getClassLoader());
        this.classLoaders.add(classLoader);
        String pluginClassName = props.getProperty("pluginClass");
        if (StringUtils.isBlank((String)pluginClassName)) {
            pluginClassName = NotInteractivePlugin.class.getName();
        }
        if (StringUtils.isBlank((String)(rendererId = props.getProperty("rendererId")))) {
            LOGGER.log(Level.WARN, "no renderer defined by this plugin [" + plugin + "]\uff0cthis plugin will be ignore!");
            return null;
        }
        Class<?> pluginClass = classLoader.loadClass(pluginClassName);
        LOGGER.log(Level.TRACE, "Loading plugin class [name={}]", (Object)pluginClassName);
        AbstractPlugin ret = (AbstractPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ret.setRendererId(rendererId);
        PluginManager.setPluginProps(plugin, ret, props);
        this.register(ret, holder);
        ret.changeStatus();
        return ret;
    }

    private void register(AbstractPlugin plugin, Map<String, Set<AbstractPlugin>> holder) {
        String rendererId = plugin.getRendererId();
        Arrays.asList(rendererId.split(";")).forEach(rid -> holder.computeIfAbsent((String)rid, k -> new HashSet()).add(plugin));
        LOGGER.log(Level.DEBUG, "Registered plugin [name={}, version={}] for rendererId [name={}], [{}] plugins totally", (Object)plugin.getName(), (Object)plugin.getVersion(), (Object)rendererId, (Object)holder.size());
    }

    static void setPluginProps(String pluginDirName, AbstractPlugin plugin, Properties props) {
        String author = props.getProperty("author");
        String name = props.getProperty("name");
        String version = props.getProperty("version");
        String types = props.getProperty("types");
        LOGGER.log(Level.TRACE, "Plugin [name={}, author={}, version={}, types={}]", (Object)name, (Object)author, (Object)version, (Object)types);
        plugin.setAuthor(author);
        plugin.setName(name);
        plugin.setId(name + "_" + version);
        plugin.setVersion(version);
        plugin.setDir(pluginDirName);
        plugin.readLangs();
        File settingFile = Latkes.getFile("/plugins/" + pluginDirName + "/config.json");
        if (null != settingFile && settingFile.exists()) {
            try {
                String config = FileUtils.readFileToString((File)settingFile, (Charset)Charset.defaultCharset());
                JSONObject jsonObject = new JSONObject(config);
                plugin.setSetting(jsonObject);
            }
            catch (IOException ie) {
                LOGGER.log(Level.ERROR, "reading the config of the plugin [" + name + "]  failed", (Throwable)ie);
            }
            catch (JSONException e) {
                LOGGER.log(Level.ERROR, "convert the  config of the plugin [" + name + "] to json failed", (Throwable)e);
            }
        }
        Arrays.stream(types.split(",")).map(PluginType::valueOf).forEach(plugin::addType);
    }

    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(this.classLoaders);
    }
}

