/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.plugin;

import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.plugin.AbstractPlugin;
import org.b3log.latke.plugin.PluginManager;
import org.b3log.latke.plugin.ViewLoadEventData;

public final class ViewLoadEventHandler
extends AbstractEventListener<ViewLoadEventData> {
    private static final Logger LOGGER = LogManager.getLogger(ViewLoadEventHandler.class);

    @Override
    public String getEventType() {
        return "FreeMarkerAction";
    }

    @Override
    public void action(Event<ViewLoadEventData> event) {
        ViewLoadEventData data = event.getData();
        String viewName = data.getViewName();
        Map<String, Object> dataModel = data.getDataModel();
        PluginManager pluginManager = BeanManager.getInstance().getReference(PluginManager.class);
        Set<AbstractPlugin> plugins = pluginManager.getPlugins(viewName);
        LOGGER.log(Level.DEBUG, "Plugin count[{}] of view[name={}]", (Object)plugins.size(), (Object)viewName);
        block4: for (AbstractPlugin plugin : plugins) {
            switch (plugin.getStatus()) {
                case ENABLED: {
                    plugin.plug(dataModel);
                    LOGGER.log(Level.DEBUG, "Plugged[name={}]", (Object)plugin.getName());
                    continue block4;
                }
                case DISABLED: {
                    plugin.unplug();
                    LOGGER.log(Level.DEBUG, "Unplugged[name={}]", (Object)plugin.getName());
                    continue block4;
                }
            }
            throw new AssertionError((Object)"Plugin state error, this is a bug! Please report this bug (https://github.com/88250/latke/issues/new)!");
        }
    }
}

