/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository;

import java.util.List;
import java.util.Objects;
import org.b3log.latke.repository.CompositeFilterOperator;
import org.b3log.latke.repository.Filter;

public final class CompositeFilter
implements Filter {
    private final CompositeFilterOperator operator;
    private final List<Filter> subFilters;

    public CompositeFilter(CompositeFilterOperator operator, List<Filter> subFilters) {
        this.operator = operator;
        this.subFilters = subFilters;
    }

    public List<Filter> getSubFilters() {
        return this.subFilters;
    }

    public CompositeFilterOperator getOperator() {
        return this.operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeFilter that = (CompositeFilter)o;
        return this.operator == that.operator && Objects.equals(this.subFilters, that.subFilters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.subFilters});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("operator=");
        stringBuilder.append((Object)this.operator).append(", filters=[");
        for (int i = 0; i < this.subFilters.size(); ++i) {
            Filter filter = this.subFilters.get(i);
            stringBuilder.append("filter=[").append(filter.toString()).append("]");
            if (i >= this.subFilters.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

