/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.util.Callstacks;

public final class Connections {
    private static final Logger LOGGER = LogManager.getLogger(Connections.class);
    private static HikariDataSource hikari;
    private static int transactionIsolationInt;
    private static String url;
    private static String userName;
    private static String password;

    public static int getTotalConnectionCount() {
        if (Latkes.RuntimeDatabase.NONE == Latkes.getRuntimeDatabase()) {
            return -1;
        }
        return hikari.getHikariPoolMXBean().getTotalConnections();
    }

    public static int getMaxConnectionCount() {
        if (Latkes.RuntimeDatabase.NONE == Latkes.getRuntimeDatabase()) {
            return -1;
        }
        return hikari.getMaximumPoolSize();
    }

    public static int getActiveConnectionCount() {
        if (Latkes.RuntimeDatabase.NONE == Latkes.getRuntimeDatabase()) {
            return -1;
        }
        return hikari.getHikariPoolMXBean().getActiveConnections();
    }

    public static Connection getConnection() throws SQLException {
        if (LOGGER.isTraceEnabled()) {
            Callstacks.printCallstack(Level.TRACE, new String[]{"org.b3log"}, null);
        }
        if (Latkes.RuntimeDatabase.NONE == Latkes.getRuntimeDatabase()) {
            return null;
        }
        Connection ret = hikari.getConnection();
        ret.setTransactionIsolation(transactionIsolationInt);
        ret.setAutoCommit(false);
        return ret;
    }

    public static void shutdownConnectionPool() {
        if (null == hikari) {
            return;
        }
        hikari.close();
        LOGGER.debug("Closed database connection pool");
    }

    public static boolean isClosed() {
        if (null == hikari) {
            return true;
        }
        return hikari.isClosed();
    }

    private Connections() {
    }

    static {
        try {
            if (Latkes.RuntimeDatabase.NONE != Latkes.getRuntimeDatabase()) {
                String driver = Latkes.getLocalProperty("jdbc.driver");
                Class.forName(driver);
                url = Latkes.getLocalProperty("jdbc.URL");
                userName = Latkes.getLocalProperty("jdbc.username");
                password = Latkes.getLocalProperty("jdbc.password");
                int minConnCnt = Integer.valueOf(Latkes.getLocalProperty("jdbc.minConnCnt"));
                int maxConnCnt = Integer.valueOf(Latkes.getLocalProperty("jdbc.maxConnCnt"));
                String transactionIsolation = Latkes.getLocalProperty("jdbc.transactionIsolation");
                if (StringUtils.isBlank((String)transactionIsolation)) {
                    transactionIsolationInt = 2;
                } else if ("NONE".equals(transactionIsolation)) {
                    transactionIsolationInt = 0;
                } else if ("READ_COMMITTED".equals(transactionIsolation)) {
                    transactionIsolationInt = 2;
                } else if ("READ_UNCOMMITTED".equals(transactionIsolation)) {
                    transactionIsolationInt = 1;
                } else if ("REPEATABLE_READ".equals(transactionIsolation)) {
                    transactionIsolationInt = 4;
                } else if ("SERIALIZABLE".equals(transactionIsolation)) {
                    transactionIsolationInt = 8;
                } else {
                    throw new IllegalStateException("Undefined transaction isolation [" + transactionIsolation + ']');
                }
                LOGGER.log(Level.DEBUG, "Initialing database connection pool [hikari]");
                Properties props = new Properties();
                InputStream is = Connections.class.getResourceAsStream("/hikari.properties");
                if (null != is) {
                    props.load(is);
                    HikariConfig hikariConfig = new HikariConfig(props);
                    hikari = new HikariDataSource(hikariConfig);
                    LOGGER.log(Level.INFO, "Created datasource with hikari.properties");
                } else {
                    hikari = new HikariDataSource();
                    hikari.setConnectionTestQuery("SELECT 1");
                    if (Latkes.RuntimeDatabase.MYSQL == Latkes.getRuntimeDatabase()) {
                        hikari.addDataSourceProperty("dataSource.cachePrepStmts", (Object)true);
                        hikari.addDataSourceProperty("dataSource.prepStmtCacheSize", (Object)256);
                        hikari.addDataSourceProperty("dataSource.prepStmtCacheSqlLimit", (Object)2048);
                        hikari.addDataSourceProperty("dataSource.useServerPrepStmts", (Object)true);
                        hikari.addDataSourceProperty("dataSource.useLocalSessionState", (Object)true);
                        hikari.addDataSourceProperty("dataSource.rewriteBatchedStatements", (Object)true);
                        hikari.addDataSourceProperty("dataSource.cacheResultSetMetadata", (Object)true);
                        hikari.addDataSourceProperty("dataSource.cacheServerConfiguration", (Object)true);
                        hikari.addDataSourceProperty("dataSource.elideSetAutoCommits", (Object)true);
                        hikari.addDataSourceProperty("dataSource.maintainTimeStats", (Object)false);
                    }
                    hikari.setValidationTimeout(2000L);
                    hikari.setConnectionTimeout(2000L);
                    hikari.setLeakDetectionThreshold(300000L);
                    hikari.setUsername(userName);
                    hikari.setPassword(password);
                    hikari.setJdbcUrl(url);
                    hikari.setDriverClassName(driver);
                    hikari.setMinimumIdle(minConnCnt);
                    hikari.setMaximumPoolSize(maxConnCnt);
                }
                LOGGER.info("Initialized database connection pool [hikari]");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can not initialize database connection pool", (Throwable)e);
        }
    }
}

