/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.ArrayList;
import java.util.List;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.util.Strings;

public final class Paginator {
    public static int getPage(RequestContext context) {
        return Paginator.getPage(context.getRequest());
    }

    public static int getPage(Request request) {
        int ret = 1;
        String p = request.getParameter("p");
        if (Strings.isNumeric(p)) {
            try {
                ret = Integer.parseInt(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (1 > ret) {
            ret = 1;
        }
        return ret;
    }

    public static List<Integer> paginate(int currentPageNum, int pageSize, int pageCount, int windowSize) {
        ArrayList<Integer> ret;
        if (pageCount < windowSize) {
            ret = new ArrayList<Integer>(pageCount);
            for (int i = 0; i < pageCount; ++i) {
                ret.add(i, i + 1);
            }
        } else {
            ret = new ArrayList(windowSize);
            int first = currentPageNum + 1 - windowSize / 2;
            first = first < 1 ? 1 : first;
            first = first + windowSize > pageCount ? pageCount - windowSize + 1 : first;
            for (int i = 0; i < windowSize; ++i) {
                ret.add(i, first + i);
            }
        }
        return ret;
    }

    private Paginator() {
    }
}

