/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.guards;

import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryDownloader;
import com.subgraph.orchid.GuardEntry;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Threading;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.guards.Bridges;
import com.subgraph.orchid.circuits.guards.GuardProbeTask;
import com.subgraph.orchid.circuits.path.CircuitNodeChooser;
import com.subgraph.orchid.circuits.path.RouterFilter;
import com.subgraph.orchid.crypto.TorRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class EntryGuards {
    private static final Logger logger = Logger.getLogger(EntryGuards.class.getName());
    private static final int MIN_USABLE_GUARDS = 2;
    private static final int NUM_ENTRY_GUARDS = 3;
    private final TorConfig config;
    private final TorRandom random;
    private final CircuitNodeChooser nodeChooser;
    private final ConnectionCache connectionCache;
    private final Directory directory;
    private final Set<GuardEntry> pendingProbes;
    private final Bridges bridges;
    private final Object lock;
    private final Executor executor;
    private static final long ONE_HOUR = EntryGuards.hoursToMs(1L);
    private static final long FOUR_HOURS = EntryGuards.hoursToMs(4L);
    private static final long SIX_HOURS = EntryGuards.hoursToMs(6L);
    private static final long EIGHTEEN_HOURS = EntryGuards.hoursToMs(18L);
    private static final long THIRTYSIX_HOURS = EntryGuards.hoursToMs(36L);
    private static final long THREE_DAYS = EntryGuards.daysToMs(3L);
    private static final long SEVEN_DAYS = EntryGuards.daysToMs(7L);
    private static final long THIRTY_DAYS = EntryGuards.daysToMs(30L);
    private static final long SIXTY_DAYS = EntryGuards.daysToMs(60L);

    public EntryGuards(TorConfig config, ConnectionCache connectionCache, DirectoryDownloader directoryDownloader, Directory directory) {
        this.config = config;
        this.random = new TorRandom();
        this.nodeChooser = new CircuitNodeChooser(config, directory);
        this.connectionCache = connectionCache;
        this.directory = directory;
        this.pendingProbes = new HashSet<GuardEntry>();
        this.bridges = new Bridges(config, directoryDownloader);
        this.lock = new Object();
        this.executor = Threading.newPool("EntryGuards worker");
    }

    public boolean isUsingBridges() {
        return this.config.getUseBridges();
    }

    public Router chooseRandomGuard(Set<Router> excluded) throws InterruptedException {
        if (this.config.getUseBridges()) {
            return this.bridges.chooseRandomBridge(excluded);
        }
        List<Router> usableGuards = this.getMinimumUsableGuards(excluded, 2);
        int n = Math.min(usableGuards.size(), 3);
        return usableGuards.get(this.random.nextInt(n));
    }

    private List<Router> getMinimumUsableGuards(Set<Router> excluded, int minSize) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.testStatusOfAllGuards();
            while (true) {
                List<Router> usableGuards;
                if ((usableGuards = this.getUsableGuardRouters(excluded)).size() >= minSize) {
                    return usableGuards;
                }
                this.maybeChooseNew(usableGuards.size(), minSize, this.getExcludedForChooseNew(excluded, usableGuards));
                this.lock.wait(5000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void probeConnectionSucceeded(GuardEntry entry) {
        Object object = this.lock;
        synchronized (object) {
            this.pendingProbes.remove(entry);
            if (entry.isAdded()) {
                this.retestProbeSucceeded(entry);
            } else {
                this.initialProbeSucceeded(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void probeConnectionFailed(GuardEntry entry) {
        Object object = this.lock;
        synchronized (object) {
            this.pendingProbes.remove(entry);
            if (entry.isAdded()) {
                this.retestProbeFailed(entry);
            }
            this.lock.notifyAll();
        }
    }

    private void retestProbeSucceeded(GuardEntry entry) {
        entry.clearDownSince();
    }

    private void initialProbeSucceeded(GuardEntry entry) {
        logger.fine("Probe connection to " + entry.getRouterForEntry() + " succeeded.  Adding it as a new entry guard.");
        this.directory.addGuardEntry(entry);
        this.retestAllUnreachable();
    }

    private void retestProbeFailed(GuardEntry entry) {
        entry.markAsDown();
    }

    private void retestAllUnreachable() {
        for (GuardEntry e : this.directory.getGuardEntries()) {
            if (e.getDownSince() == null) continue;
            this.launchEntryProbe(e);
        }
    }

    private void testStatusOfAllGuards() {
        for (GuardEntry entry : this.directory.getGuardEntries()) {
            if (this.isPermanentlyUnlisted(entry) || this.isExpired(entry)) {
                this.directory.removeGuardEntry(entry);
                continue;
            }
            if (!this.needsUnreachableTest(entry)) continue;
            this.launchEntryProbe(entry);
        }
    }

    private List<Router> getUsableGuardRouters(Set<Router> excluded) {
        ArrayList<Router> usableRouters = new ArrayList<Router>();
        for (GuardEntry entry : this.directory.getGuardEntries()) {
            this.addRouterIfUsableAndNotExcluded(entry, excluded, usableRouters);
        }
        return usableRouters;
    }

    private void addRouterIfUsableAndNotExcluded(GuardEntry entry, Set<Router> excluded, List<Router> routers) {
        Router r;
        if (entry.testCurrentlyUsable() && entry.getDownSince() == null && (r = entry.getRouterForEntry()) != null && !excluded.contains(r)) {
            routers.add(r);
        }
    }

    private Set<Router> getExcludedForChooseNew(Set<Router> excluded, List<Router> usable) {
        HashSet<Router> set = new HashSet<Router>();
        set.addAll(excluded);
        set.addAll(usable);
        this.addPendingInitialConnections(set);
        return set;
    }

    private void addPendingInitialConnections(Set<Router> routerSet) {
        for (GuardEntry entry : this.pendingProbes) {
            Router r;
            if (entry.isAdded() || (r = entry.getRouterForEntry()) == null) continue;
            routerSet.add(r);
        }
    }

    private void maybeChooseNew(int usableSize, int minSize, Set<Router> excluded) {
        for (int sz = usableSize + this.countPendingInitialProbes(); sz < minSize; ++sz) {
            Router newGuard = this.chooseNewGuard(excluded);
            if (newGuard == null) {
                logger.warning("Need to add entry guards but no suitable guard routers are available");
                return;
            }
            logger.fine("Testing " + newGuard + " as a new guard since we only have " + usableSize + " usable guards");
            GuardEntry entry = this.directory.createGuardEntryFor(newGuard);
            this.launchEntryProbe(entry);
        }
    }

    private int countPendingInitialProbes() {
        int count = 0;
        for (GuardEntry entry : this.pendingProbes) {
            if (entry.isAdded()) continue;
            ++count;
        }
        return count;
    }

    private Router chooseNewGuard(final Set<Router> excluded) {
        return this.nodeChooser.chooseRandomNode(CircuitNodeChooser.WeightRule.WEIGHT_FOR_GUARD, new RouterFilter(){

            @Override
            public boolean filter(Router router) {
                return router.isValid() && router.isPossibleGuard() && router.isRunning() && !excluded.contains(router);
            }
        });
    }

    private void launchEntryProbe(GuardEntry entry) {
        if (!entry.testCurrentlyUsable() || this.pendingProbes.contains(entry)) {
            return;
        }
        this.pendingProbes.add(entry);
        this.executor.execute(new GuardProbeTask(this.connectionCache, this, entry));
    }

    private boolean isPermanentlyUnlisted(GuardEntry entry) {
        Date unlistedSince = entry.getUnlistedSince();
        if (unlistedSince == null || this.pendingProbes.contains(entry)) {
            return false;
        }
        Date now = new Date();
        long unlistedTime = now.getTime() - unlistedSince.getTime();
        return unlistedTime > THIRTY_DAYS;
    }

    private boolean isExpired(GuardEntry entry) {
        Date createdAt = entry.getCreatedTime();
        Date now = new Date();
        long createdAgo = now.getTime() - createdAt.getTime();
        return createdAgo > SIXTY_DAYS;
    }

    private boolean needsUnreachableTest(GuardEntry entry) {
        Date downSince = entry.getDownSince();
        if (downSince == null || !entry.testCurrentlyUsable()) {
            return false;
        }
        Date now = new Date();
        Date lastConnect = entry.getLastConnectAttempt();
        long timeDown = now.getTime() - downSince.getTime();
        long timeSinceLastRetest = lastConnect == null ? timeDown : now.getTime() - lastConnect.getTime();
        return timeSinceLastRetest > this.getRetestInterval(timeDown);
    }

    private static long hoursToMs(long n) {
        return TimeUnit.MILLISECONDS.convert(n, TimeUnit.HOURS);
    }

    private static long daysToMs(long n) {
        return TimeUnit.MILLISECONDS.convert(n, TimeUnit.DAYS);
    }

    private long getRetestInterval(long timeDown) {
        if (timeDown < SIX_HOURS) {
            return ONE_HOUR;
        }
        if (timeDown < THREE_DAYS) {
            return FOUR_HOURS;
        }
        if (timeDown < SEVEN_DAYS) {
            return EIGHTEEN_HOURS;
        }
        return THIRTYSIX_HOURS;
    }
}

